/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.capability.edit;

import java.util.List;
import oracle.bpm.command.Command;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.WordWrapHelper;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.lang.Str;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.text.NonScrollTextArea;
import oracle.bpm.ui.text.TextComponent;
import org.jetbrains.annotations.NotNull;

public abstract class LabelInplaceEditCapability
extends Capability {
    private TextComponent component;
    private final int DIEGOR_MAGIC_NUMBER = 4;
    private DocumentListener documentListener;
    private FocusListener focusListener;
    private Font font;
    private boolean isEditing;
    private KeyListener keyListener;
    private DrawableLabel label;
    private static int MIN_EDITING_WIDTH = 20;
    private static int EDITING_GAP = 6;

    protected LabelInplaceEditCapability(@NotNull CapableController controller, @NotNull DrawableLabel label) {
        super(CapabilityType.EDIT, controller);
        this.label = label;
        this.setSpecifyParent(false);
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        this.startEditing();
        return null;
    }

    public void stopEditing() {
        if (this.isEditing()) {
            String newText = this.getUITextComponent().getText();
            String oldText = this.label.getLabel();
            if (!oldText.equals(newText) && !Str.isEmpty(newText)) {
                this.setModelObjectNewLabel(newText);
            }
            this.label.setHidden(false);
            this.getUITextComponent().setVisible(false);
            this.setEditing(false);
        }
    }

    public Rectangle getMultiLineBounds(@NotNull Rectangle bounds, @NotNull String str, @NotNull FontMetrics fontMetrics) {
        int scaledMaxWidth = this.getScaledMultilineMaxWidth();
        int width = Math.min(fontMetrics.stringWidth(str), scaledMaxWidth);
        width = this.normalizeMinWidth(width);
        int lineHeight = fontMetrics.getHeight();
        List<String> lines = WordWrapHelper.wrap(str, fontMetrics, scaledMaxWidth);
        int height = lines.size() > 0 ? lines.size() * lineHeight : lineHeight;
        height += 4;
        height = this.normalizeMinHeight(height);
        return Rectangle.valueOf(new Point(bounds.getCenterX() - width / 2, bounds.getY()), width, height);
    }

    public Rectangle getSingleLineBounds(@NotNull Rectangle bounds, @NotNull String str, @NotNull FontMetrics fontMetrics) {
        int width = this.normalizeMinWidth(fontMetrics.stringWidth(str));
        int height = fontMetrics.getHeight() + 4;
        height = this.normalizeMinHeight(height);
        return Rectangle.createAround(bounds.getCenter(), width, height);
    }

    protected abstract void setModelObjectNewLabel(@NotNull String var1);

    private int getScaledMultilineMaxWidth() {
        int maxWidth = WordWrapHelper.MULTILINE_MAX_WIDTH;
        return this.getContext().scale(maxWidth);
    }

    private void startEditing() {
        if (!this.isEditing()) {
            TextComponent component = this.getUITextComponent();
            DiagramContext context = this.getContext();
            Point offset = this.label.getContainer().getAbsoluteOffset();
            Rectangle bounds = context.scale(this.label.getBounds()).translate(offset);
            int width = this.normalizeMinWidth(bounds.getWidth());
            int height = this.normalizeMinHeight(bounds.getHeight());
            bounds = Rectangle.createAround(bounds.getCenter().translate(0, 3), width, height);
            component.setText(this.label.getLabel());
            component.setBounds(bounds);
            component.setFont(this.font.scale(context.getScale()));
            component.setForeground(Color.BLACK);
            component.selectAll();
            component.setVisible(true);
            component.setFocusable(true);
            component.requestFocus();
            this.setEditing(true);
            this.label.setHidden(true);
            this.getCanvas().repaint();
        }
    }

    private TextComponent getUITextComponent() {
        if (this.component == null) {
            PaintCanvas canvas = this.getCanvas();
            NonScrollTextArea field = new NonScrollTextArea(canvas);
            field.setOpaque(false);
            field.setLineWrap(true);
            field.setWrapStyleWord(true);
            this.component = field;
            canvas.add(this.component);
            this.addComponentListeners();
            this.font = this.component.getFont();
        }
        return this.component;
    }

    private void addComponentListeners() {
        if (this.focusListener == null) {
            this.focusListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    LabelInplaceEditCapability.this.stopEditing();
                    LabelInplaceEditCapability.this.getCanvas().repaint();
                }
            };
            this.component.addFocusListener(this.focusListener);
        }
        if (this.keyListener == null) {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    if (event.isEscape() || event.isEnter()) {
                        LabelInplaceEditCapability.this.stopEditing();
                        LabelInplaceEditCapability.this.getCanvas().repaint();
                        event.consume();
                    }
                }
            };
            this.component.addKeyListener(this.keyListener);
        }
        if (this.documentListener == null) {
            this.documentListener = new DocumentListener.Default(){

                @Override
                public void anyUpdate(DocumentEvent event) {
                    Rectangle bounds = LabelInplaceEditCapability.this.component.getBounds();
                    FontMetrics fontMetrics = LabelInplaceEditCapability.this.component.getFontMetrics(LabelInplaceEditCapability.this.component.getFont());
                    Rectangle newBounds = LabelInplaceEditCapability.this.label.isMultiLine() ? LabelInplaceEditCapability.this.getMultiLineBounds(bounds, LabelInplaceEditCapability.this.component.getText(), fontMetrics) : LabelInplaceEditCapability.this.getSingleLineBounds(bounds, LabelInplaceEditCapability.this.component.getText(), fontMetrics);
                    LabelInplaceEditCapability.this.component.setBounds(newBounds);
                }
            };
            this.component.addDocumentListener(this.documentListener);
        }
    }

    private PaintCanvas getCanvas() {
        return this.getController().getDomain().getCanvas();
    }

    private DiagramContext getContext() {
        Domain domain = this.getController().getDomain();
        return domain.getContext();
    }

    private int getScaledMinWidth() {
        return this.getContext().scale(MIN_EDITING_WIDTH);
    }

    private int getScaledMinHeight() {
        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
        return fontMetrics.getHeight();
    }

    private void setEditing(boolean editing) {
        this.isEditing = editing;
    }

    private boolean isEditing() {
        return this.isEditing;
    }

    private int normalizeMinWidth(int width) {
        return Math.max(width, this.getScaledMinWidth()) + this.getContext().scale(EDITING_GAP);
    }

    private int normalizeMinHeight(int height) {
        return Math.max(height, this.getScaledMinHeight());
    }
}

