/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.capability.drag;

import oracle.bpm.command.Command;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.animation.Animation;
import oracle.bpm.diagram.editor.animation.AnimationBuilder;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.DraggableCapability;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public abstract class ImageDraggableCapability
extends DraggableCapability {
    private Point distance = Point.ORIGIN;
    private Drawable feedback;
    private Point initial = Point.ORIGIN;

    protected ImageDraggableCapability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        super(type, controller);
    }

    @Override
    public void startDrag(@NotNull CapabilityEvent event) {
        this.feedback = this.createFeedbackImage();
        this.startDrag(this.feedback, event);
    }

    @Override
    public void drag(@NotNull CapabilityEvent event) {
        Rectangle prevDragRectangle = this.buildFeedbackDirtyRegionRectangle();
        this.drag(this.feedback, this.getDestination(event.getLocation()), event);
        Rectangle postDragRectangle = this.buildFeedbackDirtyRegionRectangle();
        Drawable container = this.getController().getDrawableObject().getContainer();
        Rectangle repaintRegion = prevDragRectangle.union(postDragRectangle).expand(2).translate(container.getAbsoluteOffset());
        this.getDomain().getCanvas().paintImmediately(this.getDomain().getContext().scale(repaintRegion));
    }

    @Override
    public void endDrag(@NotNull CapabilityEvent event) {
        this.drop(this.feedback, this.getDestination(event.getLocation()), event);
        Rectangle rectangle = this.getDomain().getContext().scale(this.buildFeedbackDirtyRegionRectangle());
        this.getDomain().getCanvas().paintImmediately(rectangle);
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        return this.process(this.getDestination(event.getLocation()), event);
    }

    @Override
    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        if (this.feedback != null) {
            AnimationBuilder.create(this.feedback).animate(Animation.remove()).animate(Animation.translateAndRepaint(this.getDomain(), this.feedback.getLocation(), this.initial)).start();
            this.dragging = false;
        }
    }

    @NotNull
    protected abstract Drawable createFeedbackImage();

    protected abstract Command process(@NotNull Point var1, @NotNull CapabilityEvent var2);

    protected void startDrag(@NotNull Drawable feedback, @NotNull CapabilityEvent event) {
        feedback.add();
        this.distance = this.setDistanceToPointer(event);
        this.initial = this.getDestination(event.getLocation());
    }

    protected void drag(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        feedback.setLocation(destination);
    }

    protected void drop(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        feedback.remove();
    }

    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        Drawable parent = this.getController().getDrawableObject().getContainer();
        return this.feedback.getLocation().sub(event.getLocation().sub(parent.getAbsoluteOffset()));
    }

    @NotNull
    protected Point getDestination(@NotNull Point pointer) {
        Drawable object = this.getController().getDrawableObject();
        Drawable parent = object.getContainer();
        Point result = pointer.sub(parent.getAbsoluteOffset()).add(this.distance);
        result = result.max(Point.ORIGIN.add(object.getWidth() / 2, object.getHeight() / 2));
        return result;
    }

    protected Rectangle buildFeedbackDirtyRegionRectangle() {
        return this.feedback.getBounds();
    }
}

