/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.capability.add;

import oracle.bpm.command.Command;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.animation.Animation;
import oracle.bpm.diagram.editor.animation.AnimationBuilder;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.add.AddingCapability;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.PaintCanvas;
import org.jetbrains.annotations.NotNull;

public abstract class ImageAddingCapability
extends AddingCapability {
    private Point distance = Point.ORIGIN;
    private Drawable feedback;
    private Point initial = Point.ORIGIN;

    protected ImageAddingCapability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        super(type, controller);
    }

    @Override
    public void startAdd(@NotNull CapabilityEvent event) {
        this.feedback = this.createFeedbackImage(event);
        this.startAdd(this.feedback, event);
    }

    @Override
    public void updateAdd(@NotNull CapabilityEvent event) {
        Rectangle prevDragRectangle = this.buildFeedbackDirtyRegionRectangle();
        this.updateAdd(this.feedback, this.getDestination(event.getLocation()), event);
        Rectangle postDragRectangle = this.buildFeedbackDirtyRegionRectangle();
        Point offset = this.feedback.getContainer().getAbsoluteOffset();
        Rectangle repaintRegion = prevDragRectangle.union(postDragRectangle).expand(2).translate(offset);
        this.getCanvas().paintImmediately(this.getContext().scale(repaintRegion));
    }

    @Override
    public void endAdd(@NotNull CapabilityEvent event) {
        this.endAdd(this.feedback, this.getDestination(event.getLocation()), event);
        this.getCanvas().repaint();
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        return this.process(this.getDestination(event.getLocation()), event);
    }

    @Override
    public void cancelAnyVisuals(@NotNull CapabilityEvent event) {
        if (this.feedback != null) {
            AnimationBuilder.create(this.feedback).animate(Animation.remove()).animate(Animation.translateAndRepaint(this.getDomain(), this.feedback.getLocation(), this.initial)).start();
            this.adding = false;
        }
    }

    @NotNull
    protected abstract Drawable createFeedbackImage(CapabilityEvent var1);

    protected abstract Command process(@NotNull Point var1, @NotNull CapabilityEvent var2);

    protected void startAdd(@NotNull Drawable feedback, @NotNull CapabilityEvent event) {
        feedback.add();
        this.distance = this.setDistanceToPointer(event);
        this.initial = this.getDestination(event.getLocation());
        feedback.setLocation(this.getDestination(event.getLocation()));
    }

    protected void updateAdd(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        feedback.setLocation(destination);
    }

    protected void endAdd(@NotNull Drawable feedback, @NotNull Point destination, @NotNull CapabilityEvent event) {
        feedback.remove();
    }

    protected Point setDistanceToPointer(@NotNull CapabilityEvent event) {
        return this.feedback.getContainer().getAbsoluteOffset().flip();
    }

    @NotNull
    protected Point getDestination(@NotNull Point pointer) {
        return pointer.add(this.distance);
    }

    protected Rectangle buildFeedbackDirtyRegionRectangle() {
        return this.feedback.getBounds();
    }

    protected final DiagramContext getContext() {
        return this.getDomain().getContext();
    }

    protected final PaintCanvas getCanvas() {
        return this.getDomain().getCanvas();
    }
}

