/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.capability;

import java.util.Iterator;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerImpl;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapabilityModifiers;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.SpecifiedResult;
import oracle.bpm.diagram.editor.subcontroller.Subcontroller;
import org.jetbrains.annotations.NotNull;

public class CapabilityHelper {
    public static SpecifiedResult specify(@NotNull Controller<?> controller, @NotNull CapabilityType type, @NotNull CapabilityModifiers modifiers) {
        SpecifiedResult result = CapabilityHelper.singleSpecify(controller, type, modifiers);
        if (result == null) {
            Subcontroller child;
            Iterator<Subcontroller> i$ = CollectionUtils.selectInstanceOf(controller.getControllers(), Subcontroller.class).iterator();
            while (i$.hasNext() && (result = CapabilityHelper.singleSpecify(child = i$.next(), type, modifiers)) == null) {
            }
        }
        if (result == null && !(controller.getContainer() instanceof ControllerImpl.RootController)) {
            result = CapabilityHelper.specify(controller.getContainer(), type, modifiers);
        }
        return result;
    }

    private static SpecifiedResult singleSpecify(@NotNull Controller<?> controller, @NotNull CapabilityType type, @NotNull CapabilityModifiers modifiers) {
        SpecifiedResult result = null;
        if (controller instanceof CapableController) {
            CapableController capable = (CapableController)controller;
            for (Capability capability : capable.capabilities()) {
                CapabilityType specific = capability.specify(type);
                if (specific == null || !capability.accept(modifiers)) continue;
                result = SpecifiedResult.create(capability, specific);
                break;
            }
        }
        return result;
    }
}

