/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.animation;

public enum AnimatorEasing {
    LINEAR{

        @Override
        public float eval(float time, float change, float duration) {
            return change * time / duration;
        }
    }
    ,
    QUAD_IN{

        @Override
        public float eval(float time, float change, float duration) {
            return change * (time /= duration) * time;
        }
    }
    ,
    QUAD_OUT{

        @Override
        public float eval(float time, float change, float duration) {
            return -change * (time /= duration) * (time - 2.0f);
        }
    }
    ,
    QUAD_IN_OUT{

        @Override
        public float eval(float time, float change, float duration) {
            if ((time /= duration / 2.0f) < 1.0f) {
                return change / 2.0f * time * time;
            }
            return -change / 2.0f * ((time -= 1.0f) * (time - 2.0f) - 1.0f);
        }
    }
    ,
    EXP_IN{

        @Override
        public float eval(float time, float change, float duration) {
            return time == 0.0f ? 0.0f : change * (float)Math.pow(2.0, 10.0f * (time / duration - 1.0f));
        }
    }
    ,
    EXP_OUT{

        @Override
        public float eval(float time, float change, float duration) {
            return time == duration ? change : (time == 0.0f ? 0.0f : change - (change * (float)Math.pow(2.0, -10.0f * time / duration) + 1.0f));
        }
    }
    ,
    EXP_IN_OUT{

        @Override
        public float eval(float time, float change, float duration) {
            float f;
            if (time == 0.0f) {
                f = 0.0f;
            } else if (time == duration) {
                f = change;
            } else {
                float f2;
                time /= duration / 2.0f;
                f = f2 < 1.0f ? change / 2.0f * (float)Math.pow(2.0, 10.0f * (time - 1.0f)) : change / 2.0f * (float)(-Math.pow(2.0, -10.0f * (time -= 1.0f))) + 2.0f;
            }
            return f;
        }
    }
    ,
    BOUNCE_OUT{

        @Override
        public float eval(float time, float change, float duration) {
            float f;
            time /= duration;
            if ((double)f < 0.36363636363636365) {
                return change * (7.5625f * time * time);
            }
            if ((double)time < 0.7272727272727273) {
                time = (float)((double)time - 0.5454545454545454);
                return change * (7.5625f * time * time + 0.75f);
            }
            if ((double)time < 0.9090909090909091) {
                time = (float)((double)time - 0.8181818181818182);
                return change * (7.5625f * time * time + 0.9375f);
            }
            time = (float)((double)time - 0.9545454545454546);
            return change * (7.5625f * time * time + 0.984375f);
        }
    }
    ,
    BOUNCE_IN{

        @Override
        public float eval(float time, float change, float duration) {
            return change - BOUNCE_OUT.eval(duration - time, change, duration);
        }
    }
    ,
    BOUNCE_IN_OUT{

        @Override
        public float eval(float time, float change, float duration) {
            return time < duration / 2.0f ? BOUNCE_IN.eval(time * 2.0f, change, duration) * 0.5f : BOUNCE_OUT.eval(time * 2.0f - duration, change, duration) * 0.5f + change * 0.5f;
        }
    };


    public abstract float eval(float var1, float var2, float var3);
}

