/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.animation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.animation.Animation;
import oracle.bpm.diagram.editor.animation.AnimatorEasing;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import org.jetbrains.annotations.NotNull;

public class AnimationBuilder {
    private List<Animation> animations;
    private final Drawable drawable;
    private AnimatorEasing easing = AnimatorEasing.EXP_OUT;
    private float speed = 1.0f;

    AnimationBuilder(@NotNull Drawable drawable) {
        this.drawable = drawable;
        this.animations = new LinkedList<Animation>();
    }

    public static AnimationBuilder create(@NotNull Drawable drawable) {
        return new AnimationBuilder(drawable);
    }

    public void start() {
        DrawableAnimator.animate(this.drawable, this.easing, CollectionUtils.asSequence(this.animations), this.speed);
    }

    public AnimationBuilder animate(@NotNull Animation animation) {
        this.animations.add(animation);
        return this;
    }

    public AnimationBuilder easing(@NotNull AnimatorEasing easing) {
        this.easing = easing;
        return this;
    }

    public AnimationBuilder slower() {
        this.speed /= 0.7f;
        return this;
    }

    public AnimationBuilder faster() {
        this.speed *= 0.7f;
        return this;
    }

    private static class DrawableAnimator
    implements ActionListener {
        private final Sequence<Animation> animations;
        private final Drawable drawable;
        private final long duration;
        private final AnimatorEasing easing;
        private long start;
        private final Timer timer;
        private static Map<Drawable, DrawableAnimator> animators = new HashMap<Drawable, DrawableAnimator>();
        private static final int DEFAULT_DURATION = 250;

        private DrawableAnimator(@NotNull Drawable drawable, @NotNull AnimatorEasing easing, @NotNull Sequence<Animation> animations, float speed) {
            this.drawable = drawable;
            this.easing = easing;
            this.animations = animations;
            this.timer = new Timer(30, this);
            this.duration = (long)(250.0f * speed);
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            if (this.start == 0L) {
                this.start = this.time();
            }
            long now = this.time();
            long elapsed = Math.min(this.duration, now - this.start);
            this.step(this.easing.eval(elapsed, 100.0f, this.duration));
        }

        private static void animate(@NotNull Drawable drawable, @NotNull AnimatorEasing easing, @NotNull Sequence<Animation> animations, float speed) {
            DrawableAnimator animator = new DrawableAnimator(drawable, easing, animations, speed);
            DrawableAnimator other = animators.put(drawable, animator);
            if (other != null) {
                other.stop();
            }
            animator.start();
        }

        private void start() {
            this.timer.start();
        }

        private void stop() {
            this.timer.stop();
        }

        private void step(float percentage) {
            if (percentage >= 100.0f) {
                this.stop();
                percentage = 100.0f;
            }
            for (Animation animation : this.animations) {
                animation.interpolate(this.drawable, percentage);
            }
        }

        private long time() {
            return System.nanoTime() / 1000000L;
        }
    }
}

