/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.animation;

import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public abstract class Animation {
    public abstract void interpolate(@NotNull Drawable var1, float var2);

    public static Animation scale(final @NotNull Dimension origin, @NotNull Dimension target) {
        final Dimension delta = target.sub(origin);
        return new Animation(){

            @Override
            public void interpolate(@NotNull Drawable drawable, float percentage) {
                drawable.setWidth(origin.getWidth() + (int)((float)delta.getWidth() * percentage / 100.0f));
                drawable.setHeight(origin.getHeight() + (int)((float)delta.getHeight() * percentage / 100.0f));
            }
        };
    }

    public static Animation translate(final @NotNull Point origin, @NotNull Point target) {
        final Point delta = target.sub(origin);
        return new Animation(){

            @Override
            public void interpolate(@NotNull Drawable drawable, float percentage) {
                drawable.setLocation(origin.translate((int)((float)delta.getX() * percentage / 100.0f), (int)((float)delta.getY() * percentage / 100.0f)));
            }
        };
    }

    public static Animation translateAndRepaint(final @NotNull Domain domain, @NotNull Point origin, @NotNull Point target) {
        final Animation translate = Animation.translate(origin, target);
        return new Animation(){

            @Override
            public void interpolate(@NotNull Drawable drawable, float percentage) {
                Rectangle prev = drawable.getBounds();
                translate.interpolate(drawable, percentage);
                Rectangle post = drawable.getBounds();
                DiagramContext context = domain.getContext();
                Rectangle union = prev.union(post).translate(drawable.getContainer().getAbsoluteOffset());
                domain.getCanvas().paintImmediately(context.scale(union));
            }
        };
    }

    public static Animation repaint(final @NotNull Domain domain) {
        return new Animation(){

            @Override
            public void interpolate(@NotNull Drawable drawable, float percentage) {
                domain.getCanvas().repaint();
            }
        };
    }

    public static Animation remove() {
        return new Animation(){

            @Override
            public void interpolate(@NotNull Drawable drawable, float percentage) {
                if (percentage >= 100.0f) {
                    drawable.remove();
                }
            }
        };
    }
}

