/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor;

import java.util.LinkedList;
import java.util.List;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerCreator;
import oracle.bpm.diagram.editor.ControllerFactory;
import oracle.bpm.diagram.editor.ControllerImpl;
import oracle.bpm.util.LoggingUtils;
import org.jetbrains.annotations.NotNull;

public class GenericControllerFactory
extends ControllerFactory {
    private List<ControllerCreator> creators = new LinkedList<ControllerCreator>();

    public void creator(@NotNull ControllerCreator creator) {
        this.creators.add(creator);
    }

    @Override
    @NotNull
    public Controller create(Controller container, @NotNull Drawable drawable) {
        Controller result = null;
        for (ControllerCreator creator : this.creators) {
            if (creator.accepts(container, drawable)) {
                result = creator.attempt(container, drawable);
            }
            if (result == null) continue;
            break;
        }
        if (result == null) {
            LoggingUtils.assertLog("GenericControllerFactory.create", "Controller not found for drawable " + drawable + " using default controller!");
            result = new ControllerImpl(container, drawable){};
        }
        return result;
    }
}

