/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor;

import oracle.bpm.command.Command;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.DomainKeyboardManager;
import oracle.bpm.diagram.editor.DomainMouseManager;
import oracle.bpm.diagram.editor.state.AbstractDesignerState;
import oracle.bpm.diagram.editor.state.PointerState;
import org.jetbrains.annotations.NotNull;

public abstract class DomainStateManager {
    private boolean controlPressed;
    private boolean shiftPressed;
    private AbstractDesignerState currentState;
    private Domain domain;
    public static final int SELECTION_STRING_LENGTH = 6;

    public DomainStateManager(@NotNull Domain domain) {
        this.domain = domain;
        DomainKeyboardManager keyBoardManager = new DomainKeyboardManager(this);
        DomainMouseManager mouseManager = new DomainMouseManager(this);
        domain.getCanvas().addKeyListener(keyBoardManager.getKeyListener());
        domain.getCanvas().addMouseListener(mouseManager);
        domain.getCanvas().addMouseWheelListener(mouseManager);
        domain.getCanvas().addMouseMotionListener(mouseManager);
        this.setDefaultState();
    }

    public abstract void deletePressed();

    public abstract float zoomOut();

    public abstract float zoomIn();

    public abstract void scaleChanged();

    public abstract void runCommand(@NotNull Command var1);

    @Deprecated
    public abstract boolean isSimulating();

    public void checkAutoScrolling(int x, int y) {
        this.domain.getCanvas().scrollLocationToVisible(x, y);
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void repaint() {
        this.getDomain().getCanvas().repaint();
    }

    public void setCurrentState(AbstractDesignerState state) {
        state.setStateManager(this);
        this.currentState = state;
        state.init();
    }

    public AbstractDesignerState getCurrentState() {
        return this.currentState;
    }

    public void setDefaultState() {
        this.setCurrentState(new PointerState());
    }

    public void setShiftPressed(boolean shiftPressed) {
        this.shiftPressed = shiftPressed;
        if (shiftPressed) {
            this.getCurrentState().shiftPressed();
        } else {
            this.getCurrentState().shiftReleased();
        }
    }

    public void setControlPressed(boolean controlPressed) {
        this.controlPressed = controlPressed;
        if (controlPressed) {
            this.getCurrentState().controlPressed();
        } else {
            this.getCurrentState().controlReleased();
        }
    }

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }

    public boolean isControlPressed() {
        return this.controlPressed;
    }

    public static class Default
    extends DomainStateManager {
        public Default(@NotNull Domain domain) {
            super(domain);
        }

        @Override
        public void deletePressed() {
        }

        @Override
        public float zoomOut() {
            return 1.0f;
        }

        @Override
        public float zoomIn() {
            return 1.0f;
        }

        @Override
        public void scaleChanged() {
        }

        @Override
        public void runCommand(@NotNull Command command) {
        }

        @Override
        public boolean isSimulating() {
            return false;
        }
    }
}

