/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.SelectionStatus;
import oracle.bpm.lang.Platform;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import org.jetbrains.annotations.NotNull;

public abstract class DomainSelectionProvider {
    private Controller focus;
    private final List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private final DomainModifiableSelection selection = this.createHolder();

    protected DomainSelectionProvider() {
    }

    public final void addSelectionListener(@NotNull SelectionListener listener) {
        this.listeners.add(listener);
    }

    public final void removeSelectionListener(@NotNull SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public final void append(@NotNull Controller controller) {
        this.internalAppend(controller);
        this.fireSelectionChanged();
    }

    public final void remove(@NotNull Controller controller) {
        this.internalRemove(controller);
        this.fireSelectionChanged();
    }

    public final void clear() {
        if (!this.selection.isEmpty()) {
            this.internalClear();
            this.fireSelectionChanged();
        }
    }

    public Selection getSelection() {
        return this.selection;
    }

    public final void setSelection(@NotNull Controller controller) {
        this.setSelection(Collections.singletonList(controller));
    }

    public final void setSelection(@NotNull Selection selection) {
        this.setSelection(selection.asList(Controller.class));
    }

    public void setFocus(@NotNull Controller focus) {
        if (this.focus != null && !this.focus.equals(focus)) {
            this.focus.setFocus(false);
        }
        this.focus = focus;
        this.focus.setFocus(true);
    }

    protected abstract DomainModifiableSelection createHolder();

    protected void fireSelectionChanged() {
        for (SelectionListener listener : this.listeners) {
            listener.selectionChanged(this.getSelection());
        }
    }

    private void setSelection(@NotNull List<Controller> controllers) {
        DomainModifiableSelection copy = this.selection.copy();
        for (Controller controller : controllers) {
            if (copy.contains(controller)) {
                copy.remove(controller);
            }
            this.internalAppend(controller);
        }
        for (Controller removed : copy.all) {
            this.internalRemove(removed);
        }
        this.fireSelectionChanged();
    }

    private void internalAppend(Controller controller) {
        if (!this.selection.isEmpty()) {
            this.selection.last().setSelection(SelectionStatus.SELECTED);
        }
        this.selection.remove(controller);
        this.selection.add(controller);
        controller.setSelection(SelectionStatus.PRIMARY_SELECTION);
    }

    private void internalRemove(Controller controller) {
        this.selection.remove(controller);
        controller.setSelection(SelectionStatus.NONE_SELECTION);
        if (!this.selection.isEmpty()) {
            this.selection.last().setSelection(SelectionStatus.PRIMARY_SELECTION);
        }
    }

    private void internalClear() {
        for (Controller controller : this.selection.copy().all) {
            controller.setSelection(SelectionStatus.NONE_SELECTION);
        }
        this.selection.clear();
    }

    protected class DomainModifiableSelection
    implements Selection {
        protected List<Controller> all;

        protected DomainModifiableSelection() {
            this.all = new ArrayList<Controller>();
        }

        private DomainModifiableSelection(int size) {
            this.all = new ArrayList<Controller>(size);
        }

        @Override
        public boolean isMultiple() {
            return this.size() > 1;
        }

        @Override
        public boolean isSingle() {
            return this.size() == 1;
        }

        @Override
        public boolean isEmpty() {
            return this.all.isEmpty();
        }

        @Override
        public boolean isText() {
            return false;
        }

        @Override
        public int size() {
            return this.all.size();
        }

        @Override
        public <T> T as(Class<T> type) {
            Controller controller;
            T result = null;
            Iterator<Controller> i$ = this.all.iterator();
            while (i$.hasNext() && (result = (T)this.convertTo(controller = i$.next(), type)) == null) {
            }
            return result;
        }

        @Override
        public <T> List<T> asList(Class<T> type) {
            List result;
            if (this.isEmpty()) {
                result = Collections.emptyList();
            } else {
                result = new ArrayList(this.size());
                for (Controller controller : this.all) {
                    T t = this.convertTo(controller, type);
                    if (t == null) continue;
                    result.add(t);
                }
            }
            return result;
        }

        @NotNull
        public Controller last() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Attempting to get last object on an empty selection!");
            }
            return this.all.get(this.size() - 1);
        }

        protected void add(@NotNull Controller controller) {
            this.all.add(controller);
        }

        protected void remove(@NotNull Controller controller) {
            this.all.remove(controller);
        }

        protected boolean contains(@NotNull Controller controller) {
            return this.all.contains(controller);
        }

        protected void clear() {
            this.all.clear();
        }

        @NotNull
        protected DomainModifiableSelection copy() {
            DomainModifiableSelection copy = new DomainModifiableSelection(this.all.size());
            copy.all.addAll(this.all);
            return copy;
        }

        protected <V> V convertTo(Controller controller, Class<V> type) {
            V result = this.convertTo((Object)controller, type);
            if (result == null) {
                result = this.convertTo(controller.getModelObject(), type);
            }
            return result;
        }

        protected <V> V convertTo(Object object, Class<V> type) {
            V result = type.isInstance(object) ? type.cast(object) : Platform.getAdapterService().adaptTo(object, type);
            return result;
        }
    }
}

