/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.DomainStateManager;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.event.MouseMotionListener;
import org.jetbrains.annotations.NotNull;

public class DomainMouseManager
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Domain domain;
    private DomainStateManager manager;

    public DomainMouseManager(@NotNull DomainStateManager manager) {
        this.manager = manager;
        this.domain = manager.getDomain();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (!MouseEventUtilities.isPopupTrigger(event) && !event.isButton3Down()) {
            Point unscaled = this.domain.getContext().unscale(event.getX(), event.getY());
            this.manager.getCurrentState().mouseDragged(event, unscaled);
            this.manager.checkAutoScrolling(event.getX(), event.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Point unscaled = this.domain.getContext().unscale(x, y);
        this.manager.getCurrentState().mouseMoved(e, unscaled);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            if (e.getWheelRotation() > 0) {
                this.manager.zoomOut();
            } else {
                this.manager.zoomIn();
            }
            e.consume();
        } else {
            this.domain.getCanvas().notifyMouseWheelEvent(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDoubleClicked(MouseEvent e) {
        Point unscaled = this.domain.getContext().unscale(e.getX(), e.getY());
        this.manager.getCurrentState().mouseDoubleClicked(e, unscaled);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.manager.getCurrentState().mouseEntered();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.manager.getCurrentState().mouseExited();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.domain.getCanvas().requestFocus();
        Point unscaled = this.domain.getContext().unscale(e.getX(), e.getY());
        this.manager.getCurrentState().mousePressed(e, unscaled);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!MouseEventUtilities.isPopupTrigger(e)) {
            Point unscaled = this.domain.getContext().unscale(e.getX(), e.getY());
            this.manager.getCurrentState().mouseReleased(e, unscaled);
        }
    }
}

