/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor;

import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Grid;
import oracle.bpm.diagram.editor.DomainStateManager;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.util.SystemInfo;
import org.jetbrains.annotations.NotNull;

public class DomainKeyboardManager {
    private KeyListener keyListener;
    private final DomainStateManager manager;
    private static final boolean STUDIO_DEBUG_MODE = System.getProperty("fuego.studio.debug") != null;

    public DomainKeyboardManager(@NotNull DomainStateManager manager) {
        this.manager = manager;
        this.keyListener = this.initializeKeyListener();
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void shiftPressed() {
        this.manager.setShiftPressed(true);
    }

    public void shiftReleased() {
        this.manager.setShiftPressed(false);
    }

    public void escapePressed() {
        this.manager.getCurrentState().escapePressed();
    }

    private KeyListener initializeKeyListener() {
        return new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isEscape()) {
                    DomainKeyboardManager.this.escapePressed();
                } else if (e.isDelete()) {
                    DomainKeyboardManager.this.deletePressed();
                    e.consume();
                } else if (e.isEnter()) {
                    DomainKeyboardManager.this.enterPressed();
                } else if (e.isControl()) {
                    if (!SystemInfo.isAnyMac()) {
                        DomainKeyboardManager.this.controlPressed();
                    }
                } else if (e.isMeta()) {
                    if (SystemInfo.isAnyMac()) {
                        DomainKeyboardManager.this.controlPressed();
                    }
                } else if (e.isShift()) {
                    DomainKeyboardManager.this.shiftPressed();
                } else if (e.getKeyChar() == 'c') {
                    if (e.isControlDown()) {
                        DomainKeyboardManager.this.copyPressed();
                    }
                } else if (e.getKeyChar() == '+') {
                    System.out.println("DomainKeyboardManager.keyPressed :'+': INCREASE GRID");
                    DomainKeyboardManager.this.increaseGridSize();
                } else if (e.getKeyChar() == '-') {
                    System.out.println("DomainKeyboardManager.keyPressed :'-': DECREASE GRID");
                    DomainKeyboardManager.this.decreaseGridSize();
                } else if (e.getKeyChar() == 'g') {
                    System.out.println("DomainKeyboardManager.keyPressed :'g': GRID TOOGLED");
                    DomainKeyboardManager.this.toggleShowGrid();
                } else if (STUDIO_DEBUG_MODE) {
                    if (e.getKeyChar() == 'd') {
                        System.out.println("DomainKeyboardManager.keyPressed :'d': DRAWABLE DEBUG TOOGLED");
                        DomainKeyboardManager.this.toggleDebugEnabled();
                    } else if (e.getKeyChar() == 'r') {
                        System.out.println("DomainKeyboardManager.keyPressed :'r': DRAWABLE REDRAW REGIONS TOOGLED");
                        DomainKeyboardManager.this.toggleShowRedrawRegions();
                    } else if (e.getKeyChar() == 'e') {
                        System.out.println("DomainKeyboardManager.keyPressed :'e': DRAWABLE BOUNDS TOOGLED");
                        DomainKeyboardManager.this.toggleShowDrawableBounds();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isControl()) {
                    DomainKeyboardManager.this.controlReleased();
                }
                if (e.isShift()) {
                    DomainKeyboardManager.this.shiftReleased();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
    }

    private void increaseGridSize() {
        Grid grid = this.manager.getDomain().getGrid();
        grid.increaseSize();
        this.manager.scaleChanged();
    }

    private void decreaseGridSize() {
        Grid grid = this.manager.getDomain().getGrid();
        grid.decreaseSize();
        this.manager.scaleChanged();
    }

    private void toggleShowGrid() {
        DiagramContext context = this.manager.getDomain().getContext();
        boolean visible = !context.isShowGrid();
        context.setShowGrid(visible);
        System.out.println("DomainKeyboardManager.toggleShowGrid");
        System.out.println("visible = " + visible);
    }

    private void toggleShowRedrawRegions() {
        this.manager.getDomain().getContext().toggleDrawableRedrawRegions();
    }

    private void toggleDebugEnabled() {
        this.manager.getDomain().getContext().toggleDrawableDebug();
    }

    private void toggleShowDrawableBounds() {
        this.manager.getDomain().getContext().toggleDrawableBounds();
    }

    private void controlPressed() {
        this.manager.setControlPressed(true);
    }

    private void controlReleased() {
        this.manager.setControlPressed(false);
    }

    private void enterPressed() {
        this.manager.getCurrentState().enteredPressed();
    }

    private void deletePressed() {
        this.manager.getCurrentState().deletePressed();
    }

    private void copyPressed() {
        this.manager.getCurrentState().copyPressed();
    }
}

