/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor;

import oracle.bpm.collections.Predicate;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.DrawableFactory;
import oracle.bpm.diagram.draw.Grid;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerFactory;
import oracle.bpm.diagram.editor.DomainSelectionProvider;
import oracle.bpm.diagram.editor.DomainStateManager;
import oracle.bpm.diagram.editor.state.AbstractDesignerState;
import oracle.bpm.print.Printable;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Domain {
    private final PaintCanvas canvas;
    private final DiagramContext context;
    private final Object element;
    private final DomainStateManager manager;
    private final DomainSelectionProvider provider;

    protected Domain(@NotNull UiContainer parent, @NotNull Object element) {
        this.element = element;
        this.context = this.initializeContext();
        this.canvas = this.initializeCanvas(parent);
        this.provider = this.initializeSelectionProvider();
        this.manager = this.initializeDomainManager();
    }

    public abstract DrawableFactory getDrawableFactory();

    public abstract ControllerFactory getControllerFactory();

    public abstract Grid getGrid();

    public abstract Printable getDomainPrintable();

    @Nullable
    public abstract Controller<?> findController(@NotNull Predicate<Controller> var1, int var2, int var3, @Nullable Predicate<Controller> var4);

    public DiagramContext getContext() {
        return this.context;
    }

    public DomainStateManager getStateManager() {
        return this.manager;
    }

    public DomainSelectionProvider getSelectionProvider() {
        return this.provider;
    }

    public PaintCanvas getCanvas() {
        return this.canvas;
    }

    public Object getDomainElement() {
        return this.element;
    }

    public void setCurrentTool(@NotNull AbstractDesignerState state) {
        this.manager.setCurrentState(state);
    }

    protected abstract DomainSelectionProvider initializeSelectionProvider();

    protected abstract DomainStateManager initializeDomainManager();

    protected abstract DiagramContext initializeContext();

    protected abstract PaintCanvas initializeCanvas(@NotNull UiContainer var1);
}

