/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerListener;
import oracle.bpm.diagram.editor.ControllersHolder;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.SelectionStatus;
import oracle.bpm.diagram.editor.subcontroller.Subcontroller;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerImpl<T>
implements Controller<T> {
    private final Controller container;
    private final Drawable<T> drawable;
    private boolean focus;
    private final ControllersHolder<Controller> holder;
    private final List<ControllerListener> listeners;
    private SelectionStatus selection = SelectionStatus.NONE_SELECTION;

    protected ControllerImpl(@NotNull Controller container, @NotNull Drawable<T> drawable) {
        this(container, drawable, new LinkedList<ControllerListener>());
    }

    private ControllerImpl(@NotNull Drawable<T> root) {
        this(null, root, new LinkedList<ControllerListener>());
    }

    private ControllerImpl(@Nullable Controller container, @NotNull Drawable<T> drawable, @NotNull List<ControllerListener> listeners) {
        this.container = container;
        this.drawable = drawable;
        this.listeners = listeners;
        this.holder = this.createHolder();
    }

    @Override
    @NotNull
    public final T getModelObject() {
        return (T)this.drawable.getModelObject();
    }

    @Override
    @NotNull
    public Drawable<T> getDrawableObject() {
        return this.drawable;
    }

    @Override
    @NotNull
    public Domain getDomain() {
        return this.container.getDomain();
    }

    @Override
    @NotNull
    public Controller getContainer() {
        return this.container;
    }

    @NotNull
    public ControllersHolder getHolder() {
        return this.holder;
    }

    @Override
    public String getId() {
        return this.drawable.getId();
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.DEFAULT_CURSOR;
    }

    @Override
    public void setSelection(@NotNull SelectionStatus selection) {
        if (this.selection != selection) {
            this.selection = selection;
            for (ControllerListener listener : this.listeners) {
                listener.selectedStateChanged(this);
            }
            this.getDrawableObject().setShowSelection(selection.isSelected());
        }
    }

    @Override
    public void setFocus(boolean focus) {
        if (this.focus != focus) {
            this.focus = focus;
            this.getDrawableObject().setShowFocus(focus);
        }
    }

    @Override
    @NotNull
    public SelectionStatus getSelection() {
        return this.selection;
    }

    @Override
    public boolean getFocus() {
        return this.focus;
    }

    @Override
    public void editProperties() {
    }

    @Override
    public String getTooltipMessage() {
        return null;
    }

    @Override
    public void addControllerListener(@NotNull ControllerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeControllerListener(@NotNull ControllerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void add() {
        this.getDrawableObject().add();
        this.getContainer().addChild(this);
        for (ControllerListener listener : this.listeners) {
            listener.added(this);
        }
    }

    @Override
    public void remove() {
        this.getDrawableObject().remove();
        this.getContainer().removeChild(this);
        for (ControllerListener listener : this.listeners) {
            listener.removed(this);
        }
        this.listeners.clear();
    }

    @Override
    @NotNull
    public Sequence<Controller> getControllers() {
        return this.holder.getControllers();
    }

    @Override
    public boolean contains(@NotNull Controller controller) {
        return this.holder.contains(controller);
    }

    @Override
    @Nullable
    public Controller getControllerFor(@NotNull Drawable drawable) {
        return this.holder.getControllerFor(drawable);
    }

    @Override
    public void addChild(@NotNull Controller controller) {
        this.holder.add(controller);
    }

    @Override
    public void removeChild(@NotNull Controller controller) {
        this.holder.remove(controller);
    }

    @Override
    public Controller<?> findControllerAt(@NotNull Predicate<Controller> recursion, int x, int y, @Nullable Predicate<Controller> check) {
        Controller<T> result = check == null || check.check(this) ? this : null;
        Point offset = this.getDrawableObject().getAbsoluteOffset();
        int relX = x - offset.getX();
        int relY = y - offset.getY();
        for (Controller inner : this.getControllersReversed()) {
            if (!inner.getDrawableObject().contains(relX, relY) || check == null || !check.check(inner)) continue;
            if (recursion.check(inner)) {
                Controller innerFound = inner.findControllerAt(recursion, x, y, check);
                result = innerFound != null ? innerFound : inner;
                break;
            }
            result = inner;
            break;
        }
        return result;
    }

    @Override
    public void refresh() {
        HashMap childrenMap = new HashMap();
        ArrayList<Controller> toBeRefreshed = new ArrayList<Controller>();
        for (Controller controller : this.getControllers()) {
            List<Controller> list = childrenMap.put(controller.getModelObject(), Collections.singletonList(controller));
            if (list == null) continue;
            LinkedList<Controller> controllers = new LinkedList<Controller>(list);
            controllers.add(controller);
            childrenMap.put(controller.getModelObject(), controllers);
        }
        Iterable children = this.getDomain().getDrawableFactory().getChildren(this.getModelObject());
        for (Object t : children) {
            if (!childrenMap.containsKey(t)) {
                toBeRefreshed.add(this.addChildObject(t));
            }
            childrenMap.remove(t);
        }
        for (List list : childrenMap.values()) {
            for (Controller remove : list) {
                if (remove instanceof Subcontroller) continue;
                remove.remove();
            }
        }
        for (Controller controller : toBeRefreshed) {
            controller.refresh();
        }
        this.refreshDrawable();
    }

    @Override
    public void dispose() {
    }

    @NotNull
    protected Sequence<Controller> getControllersReversed() {
        return this.holder.getControllersReversed();
    }

    protected void refreshDrawable() {
        this.getDrawableObject().refresh();
    }

    protected ControllersHolder<Controller> createHolder() {
        return ControllersHolder.create();
    }

    private Controller addChildObject(@NotNull Object child) {
        Drawable drawable = this.getDomain().getDrawableFactory().create(this.getDrawableObject(), child);
        Controller controller = this.getDomain().getControllerFactory().create(this, drawable);
        controller.add();
        return controller;
    }

    public static class RootController
    extends ControllerImpl<Object> {
        private final Domain domain;

        public RootController(@NotNull Domain domain, @NotNull DrawableImpl.DrawableRoot drawable) {
            super((Drawable)drawable);
            this.domain = domain;
        }

        @Override
        public void add() {
            throw new IllegalStateException("Root Controller cannot be added nor removed!");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Root Controller cannot be added nor removed!");
        }

        @Override
        @NotNull
        public Domain getDomain() {
            return this.domain;
        }
    }
}

