/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.runtime;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.XMLSignatureParser;
import oracle.bpm.bpmobject.runtime.SortedChildrenList;
import oracle.bpm.bpmobject.runtime.XMLObject;
import oracle.bpm.bpmobject.runtime.XMLText;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;

public class XMLObjectTypeUpdater {
    private static final QName XSI_NILL_QNAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");

    private XMLObjectTypeUpdater() {
    }

    public static void updateTypeDescription(XMLObject object) {
        ObjectTypeDescription otd = object.getType().asObject();
        XMLObjectTypeUpdater.updateTypeDescription(object, otd);
    }

    public static void updateTypeDescription(XMLObject object, ObjectTypeDescription otd) {
        String objTypeDescName = otd.getQualifiedName();
        boolean isXmlOTD = XmlTypeHelper.XMLOBJECT.getQualifiedName().equals(objTypeDescName);
        if (!isXmlOTD) {
            XMLObjectTypeUpdater.setXMLObjectMetadata(otd, object.getElementNamespace(), object);
            String nativeNamespace = otd.getProperty("namespace");
            object.setNamespace(nativeNamespace);
        }
    }

    private static void setXMLObjectMetadata(ObjectTypeDescription otd, String xmlObjectElementNs, XMLObject xmlObject) {
        XMLObjectTypeUpdater.setXsiAttributes(xmlObject);
        SortedChildrenList sortedChildrenList = xmlObject.getChildren();
        List<MethodTypeDescription> attributesList = otd.getAttributes();
        for (MethodTypeDescription typeDescription : attributesList) {
            AttributeTypeDescription atd = typeDescription.asAttribute();
            boolean isSynthetic = atd.getProperty("elementNamespace") == null;
            boolean isAttribute = Boolean.valueOf(atd.getProperty("isXsdAttribute"));
            if (isSynthetic || isAttribute) continue;
            for (XMLObject child : sortedChildrenList) {
                String xsdType;
                boolean isXsdAnyType;
                if (child instanceof XMLText || (isXsdAnyType = "http://www.w3.org/2001/XMLSchema:anyType".equals(xsdType = typeDescription.getProperty("xsdType")))) continue;
                String childTagName = child.getTagName();
                String childElementNs = child.getElementNamespace();
                String elementNamespace = "".equals(childElementNs) ? xmlObjectElementNs : childElementNs;
                XMLSignatureParser xmlSignatureParser = XMLSignatureParser.buildSignature((AttributeTypeDescription)atd, (String)elementNamespace);
                String nativeName = xmlSignatureParser.getName();
                String namespace = xmlSignatureParser.getElementNamespace();
                boolean childisQualified = xmlSignatureParser.getElementIsQualified();
                if (!nativeName.equals(childTagName) || childisQualified && !namespace.equals(elementNamespace)) continue;
                XMLObjectTypeUpdater.setXsiAttributes(child);
                XMLObjectTypeUpdater.setXmlObjectFromTypeDescription(child, xmlSignatureParser, typeDescription);
            }
        }
    }

    private static void setXmlObjectFromTypeDescription(XMLObject child, XMLSignatureParser xmlSignatureParser, MethodTypeDescription mtd) {
        child.setNamespace(xmlSignatureParser.getNamespace());
        child.setElementNamespace(xmlSignatureParser.getElementNamespace());
        child.setElementIsQualified(xmlSignatureParser.getElementIsQualified());
        TypeDescription resultType = mtd.getResultType();
        if (resultType.isObject() || resultType.isArray() || resultType.isXmlObject()) {
            ObjectTypeDescription typeDescription = (ObjectTypeDescription)resultType;
            if (resultType.isArray() || resultType.isMap()) {
                typeDescription = resultType.getElementType().asObject();
            }
            if (typeDescription.isBpmObject() || typeDescription.isXmlObject()) {
                child.setFuegoName(typeDescription.getQualifiedName());
                XMLObjectTypeUpdater.setXMLObjectMetadata(typeDescription, child.getElementNamespace(), child);
            }
        }
    }

    private static void setNilAttribute(XMLObject child, Map<QName, String> attributes) {
        String nilAttribute = attributes.get(XSI_NILL_QNAME);
        boolean isNil = Boolean.parseBoolean(nilAttribute);
        if (isNil) {
            child.getAttributes().remove(XSI_NILL_QNAME);
            child.setNil(true);
        }
    }

    private static void setXsiAttributes(XMLObject child) {
        Map<QName, String> attributes = child.getAttributes();
        if (!attributes.isEmpty()) {
            XMLObjectTypeUpdater.setNilAttribute(child, attributes);
        }
    }
}

