/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.runtime;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.XMLSignatureParser;
import oracle.bpm.bpmobject.runtime.XMLElementFactory;
import oracle.bpm.bpmobject.runtime.XMLObject;
import oracle.bpm.bpmobject.runtime.XMLObjectTypeUpdater;
import oracle.bpm.component.Instantiator;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.parser.xmlparser.ElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.Parser;

class XMLInstantiator
extends Instantiator {
    XMLInstantiator() {
    }

    public static XMLObject createTree(String xml) throws ComponentExecutionException {
        XMLObject root;
        Parser xmlParser = new Parser();
        xmlParser.setElementFactory((ElementFactory)new XMLElementFactory());
        try {
            URL url = XMLInstantiator.checkFile(xml);
            if (url == null) {
                url = XMLInstantiator.checkUrl(xml);
            }
            root = url == null ? (XMLObject)xmlParser.parse(null, xml) : (XMLObject)xmlParser.parse(url);
        }
        catch (TypeParseException e) {
            throw new ComponentExecutionException(e);
        }
        XMLInstantiator.setObjectNamespaces(root);
        return root;
    }

    @Override
    public Invokeable instantiate(String qualifiedName, String componentName) throws ClassNotFoundException, ComponentExecutionException {
        return new XMLObject(componentName, new HashMap<QName, String>(), null, false);
    }

    @Override
    public Invokeable instantiate(String qualifiedName, String classname, String constructor, Object[] args) throws ClassNotFoundException, ComponentExecutionException {
        XMLObject object;
        String[] parts = XMLSignatureParser.getConstructorParts((String)constructor);
        String namespace = null;
        if (parts.length > 1) {
            namespace = parts[1];
        }
        boolean elementsAreQualified = false;
        if (parts.length > 2) {
            elementsAreQualified = parts[2].equals("elementsQualified");
        }
        Object[] inputArgs = XMLInstantiator.processInputArguments(args);
        switch (constructor.charAt(0)) {
            case 'D': {
                String name = parts[0].substring(1);
                object = new XMLObject(name, namespace, elementsAreQualified);
                break;
            }
            case 'F': {
                Map attributes = (Map)Cast.force(inputArgs[1]);
                object = new XMLObject((String)inputArgs[0], attributes, namespace, elementsAreQualified);
                break;
            }
            case 'X': {
                object = XMLInstantiator.createTree((String)inputArgs[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid constructor signature: " + constructor);
            }
        }
        object.setFuegoName(qualifiedName);
        object.setElementIsQualified(elementsAreQualified);
        XMLInstantiator.processInputAttributes(object, args);
        XMLObjectTypeUpdater.updateTypeDescription(object);
        return object;
    }

    private static URL checkUrl(String xml) {
        URL url = null;
        try {
            url = xml.startsWith("file://") ? new File(xml.substring(7)).toURI().toURL() : new URL(xml);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    private static URL checkFile(String xml) {
        URL url = null;
        try {
            File f = new File(xml).getCanonicalFile();
            if (f.exists() && f.isFile()) {
                url = f.toURI().toURL();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return url;
    }

    private static void setObjectNamespaces(XMLObject root) {
        if (!"".equals(root.getNamespace())) {
            root.setElementIsQualified(true);
        }
        for (XMLObject xmlObject : root.getChildren()) {
            XMLInstantiator.setObjectNamespaces(xmlObject);
        }
    }
}

