/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.admin.lifecycle.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.admin.lifecycle.connection.exception.CyclicPropertyException;
import oracle.bpm.admin.lifecycle.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;

public class ClassPathBuilder {
    private static ClassLoader executionClassLoader;
    private static final String RUNTIME_CLASSPATH_PROPERTIES = "/oracle/bpm/admin/lifecycle/base.runtimeclasspath.properties";
    private static final String WLS_RUNTIME_CLASSPATH_PROPERTIES = "/oracle/bpm/admin/lifecycle/wls.runtimeclasspath.properties";
    private static final String WAS_RUNTIME_CLASSPATH_PROPERTIES = "/oracle/bpm/admin/lifecycle/was.runtimeclasspath.properties";
    public static final String LIFECYCLE_JAR_DIR_PROPERTY = "oracle.bpm.lifecycle.jar.dir";
    private static final Pattern VARIABLE_PATTERN;

    public static synchronized ClassLoader getExecutionClassLoader() {
        if (executionClassLoader == null) {
            Level level = null;
            try {
                level = Level.parse("LIFECYCLE_LEVEL_HACK");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            executionClassLoader = level == null ? ClassPathBuilder.buildClassLoader() : level.getClass().getClassLoader();
        }
        return executionClassLoader;
    }

    public static List<URL> getJarsToClassPath() {
        try {
            Map<String, String> properties = ClassPathBuilder.readPropertyFile(RUNTIME_CLASSPATH_PROPERTIES);
            String platformSpecificPropertiesPath = PlatformUtils.isWeblogic() ? WLS_RUNTIME_CLASSPATH_PROPERTIES : WAS_RUNTIME_CLASSPATH_PROPERTIES;
            properties.putAll(ClassPathBuilder.readPropertyFile(platformSpecificPropertiesPath));
            HashMap<String, String> resolvedProperties = new HashMap<String, String>();
            String jarLocation = ClassPathBuilder.getThisJarDirectory().replaceAll("\\\\", "/");
            resolvedProperties.put("this.jar.dir", jarLocation);
            ArrayList<URL> jars = new ArrayList<URL>();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (!entry.getKey().startsWith("classpath.")) continue;
                jars.add(ClassPathBuilder.resolveJar(entry.getValue(), resolvedProperties, properties));
            }
            return jars;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static String getThisJarDirectory() {
        String thisJarDir = System.getProperty(LIFECYCLE_JAR_DIR_PROPERTY);
        if (thisJarDir != null) {
            return new File(thisJarDir).getAbsolutePath();
        }
        URL resource = ClassPathBuilder.class.getResource(RUNTIME_CLASSPATH_PROPERTIES);
        String urlPath = resource.getPath();
        int index = urlPath.lastIndexOf("!");
        File jar = new File(urlPath.substring(5, index));
        return jar.getAbsoluteFile().getParentFile().getAbsolutePath();
    }

    private static ClassLoader buildClassLoader() {
        List<URL> urls = ClassPathBuilder.getJarsToClassPath();
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> readPropertyFile(@NotNull String propertyFilePath) throws IOException {
        final LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(128);
        InputStream in = ClassPathBuilder.class.getResourceAsStream(propertyFilePath);
        try {
            new Properties(){

                @Override
                public Object setProperty(String key, String value) {
                    return this.put(key, value);
                }

                @Override
                public Object put(Object key, Object value) {
                    properties.put(key.toString(), value.toString());
                    return super.put(key, value);
                }
            }.load(in);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    private static URL resolveJar(String path, Map<String, String> resolvedProperties, Map<String, String> properties) throws MalformedURLException, FileNotFoundException {
        Matcher matcher = VARIABLE_PATTERN.matcher(path);
        StringBuffer strFile = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(strFile, ClassPathBuilder.resolveProperty(matcher.group(1), resolvedProperties, properties, new HashSet<String>()));
        }
        matcher.appendTail(strFile);
        File jarFile = new File(strFile.toString());
        if (!jarFile.exists()) {
            throw new FileNotFoundException("File '" + jarFile.getAbsolutePath() + "' does not exist.");
        }
        return jarFile.getAbsoluteFile().toURI().toURL();
    }

    private static String resolveProperty(String property, Map<String, String> resolvedProperties, Map<String, String> properties, Set<String> cyclic) {
        if (resolvedProperties.containsKey(property)) {
            return resolvedProperties.get(property);
        }
        if (!cyclic.contains(property)) {
            cyclic.add(property);
            try {
                Matcher matcher = VARIABLE_PATTERN.matcher(properties.get(property));
                StringBuffer value = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(value, ClassPathBuilder.resolveProperty(matcher.group(1), resolvedProperties, properties, cyclic));
                }
                matcher.appendTail(value);
                String valueStr = value.toString();
                resolvedProperties.put(property, valueStr);
                return valueStr;
            }
            catch (CyclicPropertyException e) {
                e.addProperty(property);
                throw e;
            }
        }
        throw new CyclicPropertyException(property);
    }

    static {
        VARIABLE_PATTERN = Pattern.compile("\\$\\{([\\w\\.\\-]+)\\}");
    }
}

