/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.admin.lifecycle.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassLoaderUtil {
    private static final Map<String, Class> primClasses = new HashMap<String, Class>(8, 1.0f);

    public static <T> T wrapToLocalClassLoader(@NotNull Class<T> proxyInterface, @NotNull Object targetInDifferentClassLoader) {
        return proxyInterface.cast(Proxy.newProxyInstance(ClassLoaderUtil.class.getClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)new ClassLoaderChangeInvocationHandler(targetInDifferentClassLoader, null)));
    }

    public static <T> T wrapFactoryToLocalClassLoader(@NotNull Class<T> proxyInterface, @NotNull Class<?> resultInteface, @NotNull Object targetInDifferentClassLoader) {
        return proxyInterface.cast(Proxy.newProxyInstance(ClassLoaderUtil.class.getClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)new ClassLoaderChangeInvocationHandler(targetInDifferentClassLoader, resultInteface)));
    }

    public static Object toClassLoader(final @NotNull ClassLoader classLoader, @Nullable Object object) throws ClassNotFoundException {
        if (object != null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(object);
                oout.close();
                ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
                ObjectInputStream oin = new ObjectInputStream(bin){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        String name = desc.getName();
                        try {
                            return Class.forName(name, true, classLoader);
                        }
                        catch (ClassNotFoundException e) {
                            Class cl = (Class)primClasses.get(name);
                            if (cl != null) {
                                return cl;
                            }
                            throw e;
                        }
                    }
                };
                return oin.readObject();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    public static <T> Class<T> toClassLoader(@NotNull ClassLoader classLoader, @NotNull Class<T> aClass) throws ClassNotFoundException {
        if (aClass.isPrimitive()) {
            return aClass;
        }
        return Class.forName(aClass.getName(), true, classLoader);
    }

    public static Class<?>[] toClassLoader(@NotNull ClassLoader classLoader, @NotNull Class<?>[] classes) throws ClassNotFoundException {
        Class[] result = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = ClassLoaderUtil.toClassLoader(classLoader, classes[i]);
        }
        return result;
    }

    private static Throwable changeExceptionToClassLoaders(final @NotNull ClassLoader targetClassLoader, final Throwable throwable) {
        if (throwable != null) {
            final ClassLoader sourceClassLoader = throwable.getClass().getClassLoader();
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(throwable);
                oout.close();
                ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
                ObjectInputStream oin = new ObjectInputStream(bin){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        String name = desc.getName();
                        try {
                            return Class.forName(name, true, targetClassLoader);
                        }
                        catch (ClassNotFoundException e) {
                            try {
                                return Class.forName(name, true, sourceClassLoader);
                            }
                            catch (ClassNotFoundException e1) {
                                Class cl = (Class)primClasses.get(name);
                                if (cl != null) {
                                    return cl;
                                }
                                throw e;
                            }
                        }
                        catch (NoClassDefFoundError error) {
                            throwable.printStackTrace();
                            System.err.println("\nTrying to search class: " + name);
                            error.printStackTrace();
                            return Class.forName(name, true, sourceClassLoader);
                        }
                    }
                };
                return (Throwable)oin.readObject();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (NoClassDefFoundError error) {
                return throwable;
            }
        }
        return null;
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }

    private static class ClassLoaderChangeInvocationHandler
    implements InvocationHandler {
        @NotNull
        private final ClassLoader sourceClassLoader;
        @NotNull
        private final Object target;
        @NotNull
        private final Class<?> targetClass;
        @NotNull
        private final ClassLoader targetClassLoader;
        @Nullable
        private final Class<?> wrapResultInterface;

        public ClassLoaderChangeInvocationHandler(@NotNull Object target, Class<?> wrapResultInterface) {
            this.target = target;
            this.targetClass = target.getClass();
            this.targetClassLoader = this.targetClass.getClassLoader();
            this.sourceClassLoader = this.getClass().getClassLoader();
            this.wrapResultInterface = wrapResultInterface;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Thread thread = Thread.currentThread();
            ClassLoader prevContextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.targetClassLoader);
            try {
                Class<?>[] convertedClasses = ClassLoaderUtil.toClassLoader(this.targetClassLoader, method.getParameterTypes());
                Method targetMethod = this.targetClass.getMethod(method.getName(), convertedClasses);
                targetMethod.setAccessible(true);
                Object[] convertedArgs = (Object[])ClassLoaderUtil.toClassLoader(this.targetClassLoader, args);
                Object result = targetMethod.invoke(this.target, convertedArgs);
                if (result != null) {
                    result = this.wrapResultInterface != null ? ClassLoaderUtil.wrapToLocalClassLoader(this.wrapResultInterface, result) : ClassLoaderUtil.toClassLoader(this.sourceClassLoader, result);
                }
                Object object = result;
                return object;
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw ClassLoaderUtil.changeExceptionToClassLoaders(this.sourceClassLoader, e.getCause());
            }
            finally {
                thread.setContextClassLoader(prevContextClassLoader);
            }
        }
    }
}

