/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.admin.lifecycle.msg;

import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.TMsg;

public class AdminLifecycleMsg
extends MsgBundle {
    private static final TMsg INVALID_ACTION = AdminLifecycleMsg.tmsg((String)"Invalid action '%0'");
    private static final TMsg INIT_ACTION = AdminLifecycleMsg.tmsg((String)"Executing '%0' ...");
    public static final Msg INCORRECT_ARGUMENT_MESSAGE = AdminLifecycleMsg.msg((String)"ERROR: The arguments passed in are incorrect.\n All required arguments should be passed in. Please  check for correct usage.");
    public static final Msg MDS_FILE_IS_MANDATORY = AdminLifecycleMsg.msg((String)"MDS config file is mandatory");
    public static final Msg CONNECTION_URL_IS_MANDATORY = AdminLifecycleMsg.msg((String)"Connection URL is mandatory");
    public static final Msg COMPOSER_USER_IS_MANDATORY = AdminLifecycleMsg.msg((String)"Composer user is mandatory");
    public static final Msg COMPOSER_PASSWORD_IS_MANDATORY = AdminLifecycleMsg.msg((String)"Composer password is mandatory");
    public static final Msg PROJECT_TYPE_IS_MANDATORY = AdminLifecycleMsg.msg((String)"Project type is mandatory");
    private static final TMsg INVALID_PROJECT_TYPE = AdminLifecycleMsg.tmsg((String)"Project type '%0' is invalid. Valid values: '%1");
    private static final TMsg MANDATORY_PARAMETER = AdminLifecycleMsg.tmsg((String)"Parameter '%0' is mandatory");
    public static final Msg MDS_DB_USER_REQUIRED = AdminLifecycleMsg.msg((String)"MDS database username is required when the password was specified");
    public static final Msg MDS_DB_PASSWORD_REQUIRED = AdminLifecycleMsg.msg((String)"MDS database password is required when the username was specified");
    private static final TMsg INVALID_PROJECT_LOCATION = AdminLifecycleMsg.tmsg((String)"There is not a valid project in '%0'");
    private static final TMsg INVALID_URL_CONNECTION = AdminLifecycleMsg.tmsg((String)"The url connection '%0' is invalid. The connection must be <url>:<port>.");
    private static final TMsg PUBLISH_COMPLETE = AdminLifecycleMsg.tmsg((String)"Template '%0' was successfully created in MDS");
    private static final TMsg CREATE_COMPLETE = AdminLifecycleMsg.tmsg((String)"Public share '%0' was successfully created using template '%1'");
    private static final TMsg DELETE_PUBLIC_SHARE_COMPLETE = AdminLifecycleMsg.tmsg((String)"Public share '%0' was successfully deleted.");
    private static final TMsg DELETE_TEMPLATE_COMPLETE = AdminLifecycleMsg.tmsg((String)"Template '%0' was successfully deleted.");
    private static final TMsg TEMPLATE_NOT_EXISTS = AdminLifecycleMsg.tmsg((String)"Template '%0' does not exists.");
    private static final TMsg PUBLIC_SHARE_NOT_EXISTS = AdminLifecycleMsg.tmsg((String)"Public share '%0' does not exists.");
    private static final TMsg REASSIGN_COMPLETE = AdminLifecycleMsg.tmsg((String)"Public share '%0' was successfully reassigned.");
    private static final TMsg PUBLIC_SHARE_NOT_LOCKED = AdminLifecycleMsg.tmsg((String)"Public share '%0' is not locked ");
    private static final TMsg UNLOCK_PERMISSION_ERROR = AdminLifecycleMsg.tmsg((String)"Cause: The project %0 was already locked by another user or from a different application.\nAction: The lock has to be released using the same user and application or with an Admin user.");
    private static final TMsg UNLOCK_COMPLETE = AdminLifecycleMsg.tmsg((String)"Public share '%0' unlocked successfully ");
    private static final TMsg EXPORT_PUBLIC_SHARE_COMPLETE = AdminLifecycleMsg.tmsg((String)"Public share '%0' was successfully copied to '%1'");
    private static final TMsg EXPORT_TEMPLATE_COMPLETE = AdminLifecycleMsg.tmsg((String)"Template '%0' was successfully copied to '%1'");
    public static final Msg CONNECTION_ERROR = AdminLifecycleMsg.msg((String)"Cannot establish connection");

    public static Msg INVALID_ACTION(String action) {
        return INVALID_ACTION.args(new Object[]{action});
    }

    public static Msg CREATE_COMPLETE(String project, String template) {
        return CREATE_COMPLETE.args(new Object[]{project, template});
    }

    public static Msg INIT_ACTION(String action) {
        return INIT_ACTION.args(new Object[]{action});
    }

    public static Msg UNLOCK_PERMISSION_ERROR(String publicshare) {
        return UNLOCK_PERMISSION_ERROR.args(new Object[]{publicshare});
    }

    public static Msg UNLOCK_COMPLETE(String publicShare) {
        return UNLOCK_COMPLETE.args(new Object[]{publicShare});
    }

    public static Msg DELETE_PUBLIC_SHARE_COMPLETE(String publicShare) {
        return DELETE_PUBLIC_SHARE_COMPLETE.args(new Object[]{publicShare});
    }

    public static Msg DELETE_TEMPLATE_COMPLETE(String publicShare) {
        return DELETE_TEMPLATE_COMPLETE.args(new Object[]{publicShare});
    }

    public static Msg TEMPLATE_NOT_EXISTS(String templateName) {
        return TEMPLATE_NOT_EXISTS.args(new Object[]{templateName});
    }

    public static Msg PUBLIC_SHARE_NOT_EXISTS(String publicShare) {
        return PUBLIC_SHARE_NOT_EXISTS.args(new Object[]{publicShare});
    }

    public static Msg EXPORT_PUBLIC_SHARE_COMPLETE(String publicShare, String fileSystem) {
        return EXPORT_PUBLIC_SHARE_COMPLETE.args(new Object[]{publicShare, fileSystem});
    }

    public static Msg EXPORT_TEMPLATE_COMPLETE(String templateName, String fileSystem) {
        return EXPORT_TEMPLATE_COMPLETE.args(new Object[]{templateName, fileSystem});
    }

    public static Msg PUBLISH_COMPLETE(String templateName) {
        return PUBLISH_COMPLETE.args(new Object[]{templateName});
    }

    public static Msg REASSIGN_COMPLETE(String publicShare) {
        return REASSIGN_COMPLETE.args(new Object[]{publicShare});
    }

    public static Msg PUBLIC_SHARE_NOT_LOCKED(String publicShare) {
        return PUBLIC_SHARE_NOT_LOCKED.args(new Object[]{publicShare});
    }

    public static Msg INVALID_PROJECT_LOCATION(String location) {
        return INVALID_PROJECT_LOCATION.args(new Object[]{location});
    }

    public static Msg INVALID_URL_CONNECTION(String connection) {
        return INVALID_URL_CONNECTION.args(new Object[]{connection});
    }

    public static Msg INVALID_PROJECT_TYPE(String projectType, String validValues) {
        return INVALID_PROJECT_TYPE.args(new Object[]{projectType, validValues});
    }

    public static Msg MANDATORY_PARAMETER(String parameter) {
        return MANDATORY_PARAMETER.args(new Object[]{parameter});
    }

    static {
        AdminLifecycleMsg.init(AdminLifecycleMsg.class);
    }
}

