/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.admin.lifecycle.connection;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.bpm.admin.lifecycle.connection.Connection;
import oracle.bpm.admin.lifecycle.connection.CreateOperation;
import oracle.bpm.admin.lifecycle.connection.DeleteOperation;
import oracle.bpm.admin.lifecycle.connection.ExportOperation;
import oracle.bpm.admin.lifecycle.connection.ImportOperation;
import oracle.bpm.admin.lifecycle.connection.UnlockOperation;
import oracle.bpm.admin.lifecycle.connection.exception.CannotExecuteTaskException;
import oracle.bpm.admin.lifecycle.connection.exception.InvalidArgumentException;
import oracle.bpm.admin.lifecycle.msg.AdminLifecycleMsg;
import oracle.bpm.admin.lifecycle.util.VarUtil;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdDomain;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.metadata.history.HistoryService;
import oracle.bpm.metadata.history.impl.HistoryServiceDummyMockImpl;
import oracle.bpm.metadata.impl.MdDomainImpl;
import oracle.bpm.metadata.lock.jaxb.ApplicationType;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.metadata.mds.Namespace;
import oracle.bpm.pml.security.exception.PmlSecurityExceptionFactory;
import oracle.bpm.pml.security.exception.PmlSecurityPermissionDeniedException;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.service.PmlSecurityService;
import oracle.bpm.pml.service.security.ApplicationServerConnection;
import oracle.bpm.pml.service.security.SecurityMdDomainDecorator;
import oracle.bpm.pml.service.security.SecurityRemoteService;
import oracle.bpm.pml.service.util.lookup.LookupService;
import oracle.bpm.pml.service.util.lookup.LookupServiceFactory;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.resources.Msg;
import oracle.mds.config.MDSConfigurationException;
import oracle.mds.exception.MDSException;
import oracle.mds.exception.MDSExceptionKey;
import oracle.mds.internal.util.xml.DOMUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class PMLConnection
implements Connection {
    @Nullable
    private final String appServerPort;
    @Nullable
    private final String appServerURL;
    @Nullable
    private final String composerPassword;
    @NotNull
    private final String composerUser;
    @NotNull
    private final MdDomain mdDomain;
    @NotNull
    private final String mdsConfigFile;
    @Nullable
    private final String mdsDbPassword;
    @Nullable
    private final String mdsDbUser;
    private final boolean secured;

    PMLConnection(@Nullable String appServerPort, @Nullable String appServerURL, @NotNull String composerUser, @Nullable String composerPassword, @NotNull String mdsConfigFile, @Nullable String mdsDbUser, @Nullable String mdsDbPassword) throws MalformedURLException, MDSException, MetadataException {
        this.appServerPort = appServerPort;
        this.appServerURL = appServerURL;
        this.composerPassword = composerPassword;
        this.composerUser = composerUser;
        this.mdsConfigFile = mdsConfigFile;
        this.mdsDbUser = mdsDbUser;
        this.mdsDbPassword = mdsDbPassword;
        System.setProperty("use.jaxb.composite.accesor", Boolean.TRUE.toString());
        if (VarUtil.isEmpty(composerPassword)) {
            this.secured = false;
            this.mdDomain = this.createMdDomain((HistoryService)new HistoryServiceDummyMockImpl());
        } else {
            this.secured = true;
            this.mdDomain = this.buildSecuredMdDomain();
        }
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void runCreate(@NotNull CreateOperation operation) throws CannotExecuteTaskException, InvalidArgumentException {
        this.validateCreate(operation);
        String templateId = operation.getFromId();
        String publicShareName = operation.getToName();
        String projectLocation = operation.getToPath();
        try {
            LocalRef<TemplateProject> ref = this.forceLoadTemplate(templateId);
            TemplateProject templateProject = (TemplateProject)ref.get();
            Project project = (Project)templateProject.getProject().get();
            PublicShareProject publicShare = new PublicShareProject(publicShareName, project);
            ProjectFolder location = ProjectFolder.create((String)projectLocation);
            if (!this.mdDomain.existsFolder(PublicShareProject.class, location)) {
                this.mdDomain.createFolder(PublicShareProject.class, location);
            }
            publicShare.setOwner(this.composerUser);
            publicShare.setAllowSharing(true);
            this.mdDomain.createPublicShare(location, publicShare, templateProject, this.composerUser, false, false);
            this.log(AdminLifecycleMsg.CREATE_COMPLETE(publicShareName, templateId).getString());
        }
        catch (CannotExecuteTaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotExecuteTaskException(e);
        }
    }

    @Override
    public void runDelete(@NotNull DeleteOperation operation) throws CannotExecuteTaskException, InvalidArgumentException {
        this.validateDelete(operation);
        ProjectType type = ProjectType.fromValue((String)operation.getType().toUpperCase());
        switch (type) {
            case PUBLIC_SHARED: {
                this.runDeletePublicShare(operation);
                break;
            }
            case TEMPLATE: {
                this.runDeleteTemplate(operation);
            }
        }
    }

    @Override
    public void runImport(@NotNull ImportOperation operation) throws CannotExecuteTaskException, InvalidArgumentException {
        this.validateImport(operation);
        String fsLocation = operation.getSrcDir();
        String templateName = operation.getToName();
        String projectLocation = operation.getToPath();
        boolean overWrite = operation.isOverride();
        File fsProject = new File(fsLocation);
        File fsParentDirectory = fsProject.getAbsoluteFile().getParentFile();
        if (!fsProject.isDirectory() || !fsProject.exists() || fsParentDirectory == null) {
            throw new CannotExecuteTaskException(AdminLifecycleMsg.INVALID_PROJECT_LOCATION(fsProject.getAbsolutePath()).getString());
        }
        try {
            ProjectFolder folder;
            FileProjectRepository repository = FileProjectRepository.create((File)fsParentDirectory);
            Project project = repository.create(fsProject.getName());
            if (!project.getPreferences().isTemplate()) {
                project.getPreferences().setTemplate(true);
            }
            if (!this.mdDomain.existsFolder(TemplateProject.class, folder = ProjectFolder.create((String)VFileUtils.getCanonicalPath((String)projectLocation)))) {
                this.mdDomain.createFolder(TemplateProject.class, folder);
            }
            TemplateProject templateProject = new TemplateProject(templateName, project);
            this.mdDomain.createTemplateProject(folder, templateProject, this.composerUser, overWrite, false);
            this.log(AdminLifecycleMsg.PUBLISH_COMPLETE(templateName).getString());
        }
        catch (Exception e) {
            throw new CannotExecuteTaskException(e);
        }
    }

    @Override
    public void runExport(@NotNull ExportOperation operation) throws CannotExecuteTaskException, InvalidArgumentException {
        this.validateExport(operation);
        ProjectType type = ProjectType.fromValue((String)operation.getType().toUpperCase());
        switch (type) {
            case PUBLIC_SHARED: {
                this.runExport(operation.getId(), operation.getToDir(), PublicShareProject.class, AdminLifecycleMsg.EXPORT_PUBLIC_SHARE_COMPLETE(operation.getId(), operation.getToDir()), AdminLifecycleMsg.PUBLIC_SHARE_NOT_EXISTS(operation.getId()));
                break;
            }
            case TEMPLATE: {
                this.runExport(operation.getId(), operation.getToDir(), TemplateProject.class, AdminLifecycleMsg.EXPORT_TEMPLATE_COMPLETE(operation.getId(), operation.getToDir()), AdminLifecycleMsg.TEMPLATE_NOT_EXISTS(operation.getId()));
            }
        }
    }

    @Override
    public void runUnlock(@NotNull UnlockOperation operation) throws CannotExecuteTaskException, InvalidArgumentException {
        this.validateUnlock(operation);
        String publicShareId = operation.getId();
        try {
            LocalRef ref = this.mdDomain.loadProject(PublicShareProject.class, VFileUtils.getCanonicalPath((String)publicShareId), false);
            PublicShareProject share = (PublicShareProject)ref.get();
            if (share.isLocked()) {
                this.mdDomain.releaseLock(share);
                this.log(AdminLifecycleMsg.UNLOCK_COMPLETE(publicShareId).getString());
            } else {
                this.log(AdminLifecycleMsg.PUBLIC_SHARE_NOT_LOCKED(publicShareId).getString());
            }
        }
        catch (PmlSecurityPermissionDeniedException e) {
            throw new CannotExecuteTaskException(AdminLifecycleMsg.UNLOCK_PERMISSION_ERROR(publicShareId).getString(), e);
        }
        catch (Exception e) {
            throw new CannotExecuteTaskException(e);
        }
    }

    @NotNull
    protected MdDomain buildSecuredMdDomain() throws MetadataException, MalformedURLException, MDSException {
        boolean useSSl = false;
        ApplicationServerConnection connection = new ApplicationServerConnection(false, this.appServerURL, this.appServerPort, this.composerUser, this.composerPassword, this.composerUser, this.composerPassword);
        LookupService lookupHelper = LookupServiceFactory.getLookupService();
        HistoryService historyService = lookupHelper.lookupRemoteHistoryService(connection);
        SecurityRemoteService securityService = lookupHelper.lookupRemoteSecurityService(connection);
        MdDomain mdDomain = this.createMdDomain(historyService);
        return new SecurityMdDomainDecorator(mdDomain, (PmlSecurityService)securityService);
    }

    @NotNull
    protected MdDomain createMdDomain(@NotNull HistoryService historyService) throws MalformedURLException, MDSException, MetadataException {
        File mdsConfigFile = new File(this.mdsConfigFile);
        URL mdsConfigURL = mdsConfigFile.toURI().toURL();
        if (VarUtil.isEmpty(this.mdsDbUser)) {
            return new MdDomainImpl(MdsInstanceInitializer.getMDSInstance((URL)mdsConfigURL), historyService, ApplicationType.GENERIC_APPLICATION);
        }
        try {
            Element element = this.getMdsConfigurationElement(mdsConfigURL);
            return new MdDomainImpl(MdsInstanceInitializer.getMDSInstance((Element)element), historyService, ApplicationType.GENERIC_APPLICATION);
        }
        catch (IOException e) {
            throw new MDSConfigurationException((Throwable)e, MDSExceptionKey.CONFIG_INVALID_DOCUMENT0, null);
        }
        catch (SAXException e) {
            throw new MDSConfigurationException((Throwable)e, MDSExceptionKey.CONFIG_INVALID_DOCUMENT0, null);
        }
    }

    private LocalRef<TemplateProject> forceLoadTemplate(final @NotNull String templateId) throws CannotExecuteTaskException, MetadataException {
        LocalRef ref;
        block3: {
            ref = null;
            try {
                ref = this.mdDomain.loadProject(TemplateProject.class, VFileUtils.getCanonicalPath((String)templateId), false);
            }
            catch (ProjectNotFoundException e) {
                Collection localRefs = this.mdDomain.browseProject(TemplateProject.class, (Predicate)new Predicate<TemplateProject>(){

                    public boolean check(@Nullable TemplateProject value) {
                        return value != null && value.getId().equals(templateId);
                    }
                }, null).toCollection(true);
                if (localRefs.isEmpty()) break block3;
                ref = (LocalRef)localRefs.iterator().next();
            }
        }
        if (ref == null) {
            throw new CannotExecuteTaskException(AdminLifecycleMsg.TEMPLATE_NOT_EXISTS(templateId).getString());
        }
        return ref;
    }

    private void runDeleteTemplate(@NotNull DeleteOperation operation) throws CannotExecuteTaskException {
        String templateId = operation.getId();
        boolean breakLinks = operation.isBreakLinks();
        try {
            LocalRef<TemplateProject> ref = this.forceLoadTemplate(templateId);
            TemplateProject template = (TemplateProject)ref.get();
            this.mdDomain.removeTemplate(template, breakLinks);
            this.log(AdminLifecycleMsg.DELETE_TEMPLATE_COMPLETE(templateId).getString());
        }
        catch (CannotExecuteTaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotExecuteTaskException(e);
        }
    }

    private void runDeletePublicShare(@NotNull DeleteOperation operation) throws CannotExecuteTaskException {
        String publicShareId = operation.getId();
        try {
            LocalRef ref;
            try {
                ref = this.mdDomain.loadProject(PublicShareProject.class, VFileUtils.getCanonicalPath((String)publicShareId), false);
            }
            catch (PmlSecurityPermissionDeniedException e) {
                throw PmlSecurityExceptionFactory.createPermissionDeniedException((String)this.composerUser, (ProjectRole)ProjectRole.OWNER, (ProjectRole)e.getUserRole(), (PmlSecurityPermissionDeniedException)e);
            }
            if (ref == null) {
                throw new CannotExecuteTaskException(AdminLifecycleMsg.PUBLIC_SHARE_NOT_EXISTS(publicShareId).getString());
            }
            PublicShareProject share = (PublicShareProject)ref.get();
            this.mdDomain.removePublicShare(share);
            this.log(AdminLifecycleMsg.DELETE_PUBLIC_SHARE_COMPLETE(publicShareId).getString());
        }
        catch (CannotExecuteTaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotExecuteTaskException(e);
        }
    }

    private void runExport(@NotNull String id, @NotNull String dir, @NotNull Class<? extends MdProject<?>> type, @NotNull Msg succeedMsg, @NotNull Msg failureMsg) throws CannotExecuteTaskException {
        try {
            LocalRef ref = null;
            ref = type.equals(TemplateProject.class) ? this.forceLoadTemplate(id) : this.mdDomain.loadProject(type, VFileUtils.getCanonicalPath((String)id), false);
            if (ref == null) {
                throw new CannotExecuteTaskException(failureMsg.getString());
            }
            MdProject mdProject = (MdProject)ref.get();
            LocalRef bpmProject = mdProject.getProject();
            File projectDirectory = new File(dir);
            FileProjectRepository repository = FileProjectRepository.create((File)projectDirectory);
            String projectName = mdProject.getName();
            repository.create((Project)bpmProject.get(), projectDirectory.toURI(), projectName);
            this.log(succeedMsg.getString());
        }
        catch (CannotExecuteTaskException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotExecuteTaskException(e);
        }
    }

    private void validateCreate(@NotNull CreateOperation operation) throws InvalidArgumentException {
        if (!this.secured) {
            throw new InvalidArgumentException(AdminLifecycleMsg.COMPOSER_USER_IS_MANDATORY.toString());
        }
        if (VarUtil.isEmpty(operation.getFromId())) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("fromId").toString());
        }
        if (VarUtil.isEmpty(operation.getToName())) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("toName").toString());
        }
        if (VarUtil.isEmpty(operation.getToPath())) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("toPath").toString());
        }
    }

    private void validateDelete(@NotNull DeleteOperation operation) throws InvalidArgumentException {
        if (!this.secured) {
            throw new InvalidArgumentException(AdminLifecycleMsg.COMPOSER_USER_IS_MANDATORY.toString());
        }
        if (VarUtil.isEmpty(operation.getId())) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("id").toString());
        }
        this.validateType(operation.getType());
    }

    private void validateImport(@NotNull ImportOperation operation) throws InvalidArgumentException {
        if (VarUtil.isEmpty(operation.getSrcDir())) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("srcDir").toString());
        }
        if (VarUtil.isEmpty(operation.getToName())) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("toName").toString());
        }
        if (VarUtil.isEmpty(operation.getToPath())) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("toPath").toString());
        }
    }

    private void validateExport(@NotNull ExportOperation operation) throws InvalidArgumentException {
        if (!this.secured) {
            throw new InvalidArgumentException(AdminLifecycleMsg.COMPOSER_USER_IS_MANDATORY.toString());
        }
        if (VarUtil.isEmpty(operation.getId())) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("id").toString());
        }
        if (VarUtil.isEmpty(operation.getToDir())) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("toDir").toString());
        }
        this.validateType(operation.getType());
    }

    private void validateType(@Nullable String strType) throws InvalidArgumentException {
        if (VarUtil.isEmpty(strType)) {
            throw new InvalidArgumentException(AdminLifecycleMsg.PROJECT_TYPE_IS_MANDATORY.toString());
        }
        try {
            ProjectType type = ProjectType.fromValue((String)strType.toUpperCase());
            if (type != ProjectType.TEMPLATE && type != ProjectType.PUBLIC_SHARED) {
                throw new InvalidArgumentException(AdminLifecycleMsg.INVALID_PROJECT_TYPE(strType, ProjectType.TEMPLATE.name() + " " + ProjectType.PUBLIC_SHARED.name()).toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(AdminLifecycleMsg.INVALID_PROJECT_TYPE(strType, ProjectType.TEMPLATE.name() + " " + ProjectType.PUBLIC_SHARED.name()).toString());
        }
    }

    private void validateUnlock(UnlockOperation operation) throws InvalidArgumentException {
        if (!this.secured) {
            throw new InvalidArgumentException(AdminLifecycleMsg.COMPOSER_USER_IS_MANDATORY.toString());
        }
        if (operation.getId() == null) {
            throw new InvalidArgumentException(AdminLifecycleMsg.MANDATORY_PARAMETER("id").toString());
        }
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    private Element getMdsConfigurationElement(@NotNull URL mdsConfigURL) throws IOException, SAXException {
        try {
            NodeList nodes;
            Document doc = DOMUtil.parse((URL)mdsConfigURL, (boolean)false);
            Element mdsConfigElement = null;
            if (doc != null && (nodes = doc.getElementsByTagName("mds-config")).getLength() > 0) {
                mdsConfigElement = (Element)nodes.item(0);
                XPathFactory xpathFactory = XPathFactory.newInstance();
                XPath xpath = xpathFactory.newXPath();
                String uri = "http://xmlns.oracle.com/mds/config";
                xpath.setNamespaceContext(new SimpleNamespaceContext("ns1", "http://xmlns.oracle.com/mds/config"));
                Element namespaceElement = (Element)xpath.evaluate("ns1:persistence-config/ns1:metadata-namespaces/ns1:namespace[@path='" + Namespace.BPM.getMdsNamespace().getPath() + "']", mdsConfigElement, XPathConstants.NODE);
                if (namespaceElement != null) {
                    String metadataStoreUsageId = namespaceElement.getAttribute("metadata-store-usage");
                    Element metadataStoreElement = (Element)xpath.evaluate("ns1:persistence-config/ns1:metadata-store-usages/ns1:metadata-store-usage[@id='" + metadataStoreUsageId + "']/ns1:metadata-store", mdsConfigElement, XPathConstants.NODE);
                    if (metadataStoreElement != null) {
                        this.setMetadataStoreProperty(xpath, "http://xmlns.oracle.com/mds/config", metadataStoreElement, "jdbc-userid", this.mdsDbUser);
                        this.setMetadataStoreProperty(xpath, "http://xmlns.oracle.com/mds/config", metadataStoreElement, "jdbc-password", this.mdsDbPassword);
                    }
                }
            }
            return mdsConfigElement;
        }
        catch (XPathExpressionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void setMetadataStoreProperty(XPath xpath, String uri, Element metadataStoreElement, String propertyName, String value) throws XPathExpressionException {
        Element propertyElement = (Element)xpath.evaluate("ns1:property[@name='" + propertyName + "']", metadataStoreElement, XPathConstants.NODE);
        if (propertyElement != null) {
            propertyElement.setAttribute("value", value);
        } else {
            propertyElement = metadataStoreElement.getOwnerDocument().createElementNS(uri, "property");
            propertyElement.setAttribute("name", propertyName);
            propertyElement.setAttribute("value", value);
            metadataStoreElement.appendChild(propertyElement);
        }
    }

    private static class SimpleNamespaceContext
    implements NamespaceContext {
        private final Map<String, String> prefixes;

        public SimpleNamespaceContext(Map<String, String> prefixes) {
            this.prefixes = prefixes;
        }

        public SimpleNamespaceContext(String prefix, String uri) {
            this.prefixes = new HashMap<String, String>();
            this.prefixes.put(prefix, uri);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.prefixes.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (Map.Entry<String, String> entry : this.prefixes.entrySet()) {
                if (!entry.getValue().equals(namespaceURI)) continue;
                return entry.getKey();
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return this.prefixes.keySet().iterator();
        }
    }
}

