/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.admin.lifecycle.connection;

import java.io.Serializable;
import oracle.bpm.admin.lifecycle.connection.Connection;
import oracle.bpm.admin.lifecycle.connection.PMLConnection;
import oracle.bpm.admin.lifecycle.connection.exception.ConnectionException;
import oracle.bpm.admin.lifecycle.msg.AdminLifecycleMsg;
import oracle.bpm.admin.lifecycle.util.ClassLoaderUtil;
import oracle.bpm.admin.lifecycle.util.VarUtil;
import oracle.bpm.admin.lifecycle.util.hack.HackLogLevel;
import org.jetbrains.annotations.Nullable;

public class ConnectionFactory {
    private static Interface implementation = new Default();

    private ConnectionFactory() {
    }

    public static Connection createPMLConnection(@Nullable String connectionURL, @Nullable String composerUser, @Nullable String composerPassword, @Nullable String mdsConfigFile, @Nullable String mdsDbUser, @Nullable String mdsDbPassword, boolean legacyMode) throws ConnectionException {
        return implementation.createPMLConnection(connectionURL, composerUser, composerPassword, mdsConfigFile, mdsDbUser, mdsDbPassword, legacyMode);
    }

    public static void setFactoryClassLoader(ClassLoader classLoader) {
        if (classLoader == ConnectionFactory.class.getClassLoader()) {
            implementation = new Default();
        } else {
            try {
                implementation = ClassLoaderUtil.wrapFactoryToLocalClassLoader(Interface.class, Connection.class, ClassLoaderUtil.toClassLoader(classLoader, new Default()));
                implementation.doHack();
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static class Default
    implements Interface,
    Serializable {
        private static final long serialVersionUID = 0L;

        private Default() {
        }

        @Override
        public Connection createPMLConnection(@Nullable String connectionURL, @Nullable String composerUser, @Nullable String composerPassword, @Nullable String mdsConfigFile, @Nullable String mdsDbUser, @Nullable String mdsDbPassword, boolean legacyMode) throws ConnectionException {
            if (VarUtil.isEmpty(mdsConfigFile)) {
                throw new ConnectionException(AdminLifecycleMsg.MDS_FILE_IS_MANDATORY.toString());
            }
            String appServerURL = null;
            String appServerPort = null;
            if (legacyMode && (VarUtil.isEmpty(composerPassword) || VarUtil.isEmpty(composerUser) || VarUtil.isEmpty(connectionURL))) {
                composerUser = "WLST_ADMIN";
                composerPassword = null;
                mdsDbUser = null;
                mdsDbPassword = null;
            } else {
                if (VarUtil.isEmpty(composerUser)) {
                    throw new ConnectionException(AdminLifecycleMsg.COMPOSER_USER_IS_MANDATORY.toString());
                }
                if (VarUtil.isEmpty(composerPassword)) {
                    throw new ConnectionException(AdminLifecycleMsg.COMPOSER_PASSWORD_IS_MANDATORY.toString());
                }
                if (VarUtil.isEmpty(connectionURL)) {
                    throw new ConnectionException(AdminLifecycleMsg.CONNECTION_URL_IS_MANDATORY.toString());
                }
                if (VarUtil.isEmpty(mdsDbUser) && !VarUtil.isEmpty(mdsDbPassword)) {
                    throw new ConnectionException(AdminLifecycleMsg.MDS_DB_USER_REQUIRED.toString());
                }
                if (!VarUtil.isEmpty(mdsDbUser) && VarUtil.isEmpty(mdsDbPassword)) {
                    throw new ConnectionException(AdminLifecycleMsg.MDS_DB_PASSWORD_REQUIRED.toString());
                }
                int index = connectionURL.lastIndexOf(":");
                if (index < 0) {
                    throw new ConnectionException(AdminLifecycleMsg.INVALID_URL_CONNECTION(connectionURL).toString());
                }
                appServerURL = connectionURL.substring(0, index);
                appServerPort = connectionURL.substring(index + 1, connectionURL.length());
                if (VarUtil.isEmpty(appServerURL) || VarUtil.isEmpty(appServerPort)) {
                    throw new ConnectionException(AdminLifecycleMsg.INVALID_URL_CONNECTION(connectionURL).toString());
                }
            }
            try {
                return new PMLConnection(appServerPort, appServerURL, composerUser, composerPassword, mdsConfigFile, mdsDbUser, mdsDbPassword);
            }
            catch (Exception e) {
                throw new ConnectionException(AdminLifecycleMsg.CONNECTION_ERROR.toString(), e);
            }
        }

        @Override
        public void doHack() {
            new HackLogLevel();
        }
    }

    private static interface Interface {
        public Connection createPMLConnection(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable String var5, @Nullable String var6, boolean var7) throws ConnectionException;

        public void doHack();
    }
}

