/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.admin.lifecycle.ant;

import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import oracle.bpm.admin.lifecycle.connection.Connection;
import oracle.bpm.admin.lifecycle.connection.ConnectionFactory;
import oracle.bpm.admin.lifecycle.connection.CreateOperation;
import oracle.bpm.admin.lifecycle.connection.DeleteOperation;
import oracle.bpm.admin.lifecycle.connection.ExportOperation;
import oracle.bpm.admin.lifecycle.connection.ImportOperation;
import oracle.bpm.admin.lifecycle.connection.LifeCycleOperation;
import oracle.bpm.admin.lifecycle.connection.UnlockOperation;
import oracle.bpm.admin.lifecycle.util.ClassPathBuilder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PMLProjectLifeCycleTask
extends Task {
    private String composerPassword;
    private String composerUser;
    private String connectionUrl;
    private boolean failOnError = true;
    private boolean legacyMode;
    private String mdsConfigFile;
    private String mdsDbPassword;
    private String mdsDbUser;
    private final List<LifeCycleOperation> operations = new ArrayList<LifeCycleOperation>();

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public void setComposerUser(String composerUser) {
        this.composerUser = composerUser;
    }

    public void setComposerPassword(String composerPassword) {
        this.composerPassword = composerPassword;
    }

    public void setMdsDbUser(String mdsDbUser) {
        this.mdsDbUser = mdsDbUser;
    }

    public void setMdsDbPassword(String mdsDbPassword) {
        this.mdsDbPassword = mdsDbPassword;
    }

    public void setMdsConfigFile(String mdsConfigFile) {
        this.mdsConfigFile = mdsConfigFile;
    }

    public void setLegacyMode(boolean legacyMode) {
        this.legacyMode = legacyMode;
    }

    public CreateOperation createCreate() {
        CreateOperation operation = new CreateOperation();
        operation.setToPath("/");
        this.operations.add(operation);
        return operation;
    }

    public DeleteOperation createDelete() {
        DeleteOperation operation = new DeleteOperation();
        operation.setType("TEMPLATE");
        this.operations.add(operation);
        return operation;
    }

    public ExportOperation createExport() {
        ExportOperation operation = new ExportOperation();
        operation.setType("TEMPLATE");
        this.operations.add(operation);
        return operation;
    }

    public ImportOperation createImport() {
        ImportOperation operation = new ImportOperation();
        operation.setToPath("/");
        this.operations.add(operation);
        return operation;
    }

    public UnlockOperation createUnlock() {
        UnlockOperation operation = new UnlockOperation();
        this.operations.add(operation);
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        String prevProperty = System.getProperty("javax.xml.datatype.DatatypeFactory");
        ClassLoader prevContextClassLoader = Thread.currentThread().getContextClassLoader();
        System.setProperty("javax.xml.datatype.DatatypeFactory", DatatypeFactory.DATATYPEFACTORY_IMPLEMENTATION_CLASS);
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ConnectionFactory.setFactoryClassLoader(ClassPathBuilder.getExecutionClassLoader());
        Connection connection = null;
        try {
            connection = ConnectionFactory.createPMLConnection(this.connectionUrl, this.composerUser, this.composerPassword, this.mdsConfigFile, this.mdsDbUser, this.mdsDbPassword, this.legacyMode);
            for (LifeCycleOperation operation : this.operations) {
                try {
                    operation.execute(connection);
                }
                catch (Exception e) {
                    this.log(e, 0);
                    if (!this.failOnError) continue;
                    throw new BuildException((Throwable)e);
                    return;
                }
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            this.log(e, 0);
            if (!this.failOnError) return;
            throw new BuildException((Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (prevProperty == null) {
                System.getProperties().remove("javax.xml.datatype.DatatypeFactory");
            } else {
                System.setProperty("javax.xml.datatype.DatatypeFactory", prevProperty);
            }
            Thread.currentThread().setContextClassLoader(prevContextClassLoader);
        }
    }
}

