/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw.renderer;

import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.debug.DebugableDrawer;
import oracle.bpm.diagram.draw.renderer.AbstractRenderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DebugContainerRenderer
extends AbstractRenderer {
    private DebugContainerRenderer(@NotNull Drawable container) {
        super(container);
    }

    public static DebugContainerRenderer create(@NotNull Drawable container) {
        return new DebugContainerRenderer(container);
    }

    @Override
    public void render() {
        DiagramContext context = this.getContext();
        Graphics graphics = context.getGraphics();
        Point origin = context.scale(this.getDrawable().getBounds().getOrigin());
        graphics.translate(origin);
        if (context.isDrawableBounds()) {
            for (Drawable drawable : this.getDrawable().getDrawables()) {
                graphics.setForeground(Color.GREEN);
                graphics.setStroke(Stroke.TWO_SOLID);
                Rectangle bounds = context.scale(drawable.getBounds());
                graphics.draw(bounds.shrink(1));
            }
        }
        if (context.isDrawableDebug()) {
            DebugableDrawer.drawDebugInfo(this.getDrawable());
        }
        graphics.translate(origin.flip());
        if (context.isDrawableRedrawRegions()) {
            Rectangle clip = graphics.getClipBounds();
            System.out.println("DebugContainerRenderer.render :: Showing re-draw regions when scaled CLIP > " + clip);
            graphics.setForeground(Color.YELLOW);
            graphics.setStroke(Stroke.TWO_SOLID);
            graphics.draw(clip.shrink(1));
        }
    }
}

