/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw.debug;

import java.util.LinkedList;
import java.util.List;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.debug.Debuggable;
import oracle.bpm.diagram.draw.debug.DebuggableAppender;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.DebuggableMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.util.LoggingUtils;
import org.jetbrains.annotations.NotNull;

public class DebugableFactory {
    private static List<Debuggable> debuggables;

    @NotNull
    static DebuggableAppender create(@NotNull Drawable drawable) {
        if (debuggables == null) {
            debuggables = DebugableFactory.loadDebuggables();
        }
        DebuggableAppender result = new DebuggableAppender();
        for (Debuggable debuggable : debuggables) {
            if (!debuggable.accepts(drawable)) continue;
            result.add(debuggable);
        }
        return result;
    }

    private static List<Debuggable> loadDebuggables() {
        ExtensionService service = Platform.getExtensionService();
        List<Extension<DebuggableMetadata>> all = service.getExtensionsByPoint(DebuggableMetadata.class);
        LinkedList<Debuggable> result = new LinkedList<Debuggable>();
        for (Extension<DebuggableMetadata> extension : all) {
            try {
                result.add(extension.instantiateAs(Debuggable.class));
            }
            catch (InstantiationException e) {
                LoggingUtils.assertPrintStackTrace(e);
            }
        }
        return result;
    }
}

