/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.bpm.diagram.draw.ChildrenPopulator;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableCreator;
import oracle.bpm.diagram.draw.DrawableFactory;
import org.jetbrains.annotations.NotNull;

public class GenericDrawableFactory
extends DrawableFactory {
    private List<DrawableCreator> creators = new LinkedList<DrawableCreator>();
    private List<ChildrenPopulator> populators = new LinkedList<ChildrenPopulator>();

    public void creator(@NotNull DrawableCreator creator) {
        this.creators.add(creator);
    }

    public void populator(@NotNull ChildrenPopulator populator) {
        this.populators.add(populator);
    }

    @Override
    @NotNull
    public Drawable create(Drawable parent, @NotNull Object object) {
        Drawable result = null;
        for (DrawableCreator creator : this.creators) {
            if (creator.accepts(parent, object)) {
                result = creator.attempt(parent, object);
            }
            if (result == null) continue;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Drawable Object Creation: Unknown drawable for " + object.getClass() + "!");
        }
        return result;
    }

    @NotNull
    public Iterable getChildren(@NotNull Object object) {
        Iterable<Object> result = null;
        for (ChildrenPopulator populator : this.populators) {
            if (populator.accepts(object)) {
                result = populator.attempt(object);
            }
            if (result == null) continue;
            break;
        }
        return result != null ? result : Collections.emptyList();
    }
}

