/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawablesHolder<T extends Drawable> {
    private final Map<Object, List<T>> byElement;
    private final EnumMap<DesignerLayer, TreeSet<T>> byLayer = new EnumMap(DesignerLayer.class);

    private DrawablesHolder() {
        this.byElement = new IdentityHashMap<Object, List<T>>();
    }

    public static <T extends Drawable> DrawablesHolder<T> create() {
        return new DrawablesHolder<T>();
    }

    public boolean add(@NotNull T drawable) {
        List<T> others;
        if (!DesignerLayer.shouldSkipController(drawable.getLayer()) && (others = this.byElement.put(drawable.getModelObject(), Collections.singletonList(drawable))) != null) {
            LinkedList<T> drawables = new LinkedList<T>(others);
            drawables.add(drawable);
            this.byElement.put(drawable.getModelObject(), drawables);
        }
        return this.getDrawableTreeSet(drawable.getLayer()).add(drawable);
    }

    public boolean remove(@NotNull T drawable) {
        if (!DesignerLayer.shouldSkipController(drawable.getLayer())) {
            this.byElement.remove(drawable.getModelObject());
        }
        return this.getDrawableTreeSet(drawable.getLayer()).remove(drawable);
    }

    public boolean contains(@NotNull T drawable) {
        return this.getDrawableTreeSet(drawable.getLayer()).contains(drawable);
    }

    public boolean contains(@NotNull Object element) {
        return this.byElement.containsKey(element);
    }

    @Nullable
    public T getDrawableFor(@NotNull Object element) {
        return (T)((Drawable)CollectionUtils.first((Iterable)this.byElement.get(element)));
    }

    @Nullable
    public T getDrawable(@NotNull Predicate<Drawable> condition) {
        Drawable result = null;
        block0: for (TreeSet<T> set : this.byLayer.values()) {
            for (Drawable drawable : set) {
                if (!condition.check(drawable)) continue;
                result = drawable;
                continue block0;
            }
        }
        return (T)result;
    }

    public void clear() {
        for (TreeSet<T> drawables : this.byLayer.values()) {
            drawables.clear();
        }
        this.byLayer.clear();
        this.byElement.clear();
    }

    @NotNull
    public Sequence<T> getDrawables() {
        SequenceBuilder<T> sequence = SequenceBuilder.create();
        for (TreeSet<T> set : this.byLayer.values()) {
            sequence.append((Iterable<T>)set);
        }
        return sequence.build();
    }

    @NotNull
    public Sequence<T> getAtLayer(@NotNull DesignerLayer layer) {
        return CollectionUtils.asSequence(this.getDrawableTreeSet(layer));
    }

    @NotNull
    public Sequence<T> getAtLayers(@NotNull EnumSet<DesignerLayer> layers) {
        SequenceBuilder<T> sequence = SequenceBuilder.create();
        for (DesignerLayer layer : layers) {
            sequence.append((Iterable<T>)this.getDrawableTreeSet(layer));
        }
        return sequence.build();
    }

    @NotNull
    private TreeSet<T> getDrawableTreeSet(@NotNull DesignerLayer layer) {
        TreeSet<Object> result;
        if (!this.byLayer.containsKey((Object)layer)) {
            result = new TreeSet<Drawable>(new ReverseDrawableObjectComparator());
            this.byLayer.put(layer, result);
        } else {
            result = this.byLayer.get((Object)layer);
        }
        return result;
    }

    private static class ReverseDrawableObjectComparator
    implements Comparator<Drawable> {
        private ReverseDrawableObjectComparator() {
        }

        @Override
        public int compare(Drawable first, Drawable second) {
            int layer = second.getLayer().ordinal() - first.getLayer().ordinal();
            return layer != 0 ? layer : first.compareTo(second);
        }
    }
}

