/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import java.util.List;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.WordWrapHelper;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DrawableMultiLineLabel<T>
extends DrawableLabel<T> {
    private static final Color SELECTION_BACKGROUND_COLOR = Color.valueOf(Color.FUEGO_LIGHT_BLUE, 140);
    private static final int SELECTION_BOUNDS_EXPANSION = 12;

    protected DrawableMultiLineLabel(@NotNull Drawable container, @NotNull Drawable<T> owner) {
        super(container, owner);
    }

    public static <T> DrawableMultiLineLabel<T> create(@NotNull Drawable container, @NotNull Drawable<T> owner) {
        return new DrawableMultiLineLabel<T>(container, owner);
    }

    @Override
    public boolean isMultiLine() {
        return true;
    }

    @Override
    protected void drawLabel(@NotNull Rectangle bounds) {
        Graphics graphics = this.getGraphics();
        FontMetrics metrics = graphics.getFontMetrics();
        int maxWidth = this.getScaledMaxWidth();
        List<String> lines = WordWrapHelper.wrap(this.getLabel(), metrics, maxWidth);
        int lineHeight = this.calculateLineHeight(metrics);
        Rectangle lineBounds = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), lineHeight);
        if (this.getOwner().isShowSelection()) {
            Color original = graphics.getForeground();
            graphics.setForeground(SELECTION_BACKGROUND_COLOR);
            int expansion = this.getContext().scale(12);
            graphics.fillRoundRect(bounds.getX() - expansion / 2, bounds.getY() - expansion / 6 + metrics.getMaxDescent(), bounds.getWidth() + expansion, bounds.getHeight() + expansion / 3, lineHeight, lineHeight);
            graphics.setForeground(original);
        }
        for (int i = 0; i < lines.size() && i < 3; ++i) {
            String line = lines.get(i);
            if (i == 2 && lines.size() > 3) {
                line = line.substring(0, line.length() - 3).trim() + "...";
            }
            int delta = lineBounds.getWidth() >= maxWidth ? maxWidth - metrics.stringWidth(line) : 0;
            graphics.drawString(line, lineBounds.translate(delta / 2, 0), this.getLabelBackgroundColor());
            lineBounds = lineBounds.translate(0, lineHeight);
        }
    }

    @Override
    protected int calculateLabelWidth(@NotNull String label, @NotNull FontMetrics metrics) {
        return Math.min(metrics.stringWidth(label), this.getScaledMaxWidth());
    }

    @Override
    protected int calculateLabelHeight(@NotNull String label, @NotNull FontMetrics metrics) {
        List<String> lines = WordWrapHelper.wrap(label, metrics, this.getScaledMaxWidth());
        return lines.size() * this.calculateLineHeight(metrics);
    }

    private int calculateLineHeight(@NotNull FontMetrics metrics) {
        return metrics.getMaxAscent() + metrics.getMaxDescent() + metrics.getLeading();
    }

    private int getScaledMaxWidth() {
        return this.getContext().scale(WordWrapHelper.MULTILINE_MAX_WIDTH);
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle) {
        return !this.isHidden() && this.getBounds().intersects(rectangle, 12);
    }
}

