/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import java.util.LinkedList;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableRegister;
import oracle.bpm.diagram.draw.DrawablesHolder;
import oracle.bpm.diagram.draw.renderer.ChildrenRenderer;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.PaintCanvas;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DrawableImpl<T>
implements Drawable<T> {
    private Rectangle bounds;
    private final Drawable container;
    @NotNull
    private DiagramContext context;
    private boolean focus;
    private int height;
    private boolean hidden;
    @NotNull
    private final DrawablesHolder<Drawable> holder;
    @NotNull
    private final DesignerLayer layer;
    private Point location = Point.ORIGIN;
    @NotNull
    private final T modelObject;
    private DrawableRegister register;
    @NotNull
    private final List<Renderer> renderers;
    private boolean selection;
    private final int serialId;
    private int width;
    private static final int BASIC_INTERSECTION_TOLERANCE = 6;

    protected DrawableImpl(@NotNull Drawable container, @NotNull T modelObject, @NotNull DesignerLayer layer) {
        this(container, modelObject, layer, container.getContext());
    }

    private DrawableImpl(@NotNull T modelObject, @NotNull DiagramContext context) {
        this(null, modelObject, DesignerLayer.ROOT, context);
    }

    private DrawableImpl(@Nullable Drawable container, @NotNull T modelObject, @NotNull DesignerLayer layer, @NotNull DiagramContext context) {
        this.container = container;
        this.modelObject = modelObject;
        this.layer = layer;
        this.context = context;
        this.holder = this.createHolder();
        this.renderers = this.initializeRendering();
        this.serialId = DrawableRoot.nextSerialId();
    }

    @Override
    @NotNull
    public final T getModelObject() {
        return this.modelObject;
    }

    @Override
    @NotNull
    public final DesignerLayer getLayer() {
        return this.layer;
    }

    @Override
    @NotNull
    public Drawable getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public DiagramContext getContext() {
        return this.context;
    }

    @NotNull
    public DrawablesHolder getHolder() {
        return this.holder;
    }

    @Override
    public DrawableRegister getRegister() {
        DrawableRegister register = this.getRegisterLocally();
        if (register == null) {
            register = this.getContainer().getRegister();
        }
        return register;
    }

    @Override
    public void setRegister(@Nullable DrawableRegister register) {
        this.register = register;
    }

    @Override
    public void draw() {
        for (Renderer renderer : this.renderers) {
            renderer.render();
        }
    }

    @Override
    public final int getSerialId() {
        return this.serialId;
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        if (this.needsUpdate()) {
            this.bounds = this.createBounds();
        }
        return this.bounds;
    }

    @Override
    public void setLocation(@NotNull Point location) {
        this.location = location;
    }

    @Override
    @NotNull
    public Point getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public Point getAbsoluteOffset() {
        return this.getContainer().getAbsoluteOffset().add(this.getBounds().getOrigin());
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public String getId() {
        return String.valueOf(this.getSerialId());
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle) {
        return !this.isHidden() && this.getBounds().intersects(rectangle, 6);
    }

    @Override
    public void setShowFocus(boolean focus) {
        this.focus = focus;
    }

    @Override
    public boolean isShowFocus() {
        return this.focus;
    }

    @Override
    public void setShowSelection(boolean selection) {
        this.selection = selection;
    }

    @Override
    public boolean isShowSelection() {
        return this.selection;
    }

    @Override
    public void add() {
        this.container.addChild(this);
        DrawableRegister register = this.getRegister();
        if (register != null) {
            register.register(this);
        }
    }

    @Override
    public void remove() {
        this.container.removeChild(this);
        DrawableRegister register = this.getRegister();
        if (register != null) {
            register.unregister(this);
        }
    }

    @Override
    @NotNull
    public Sequence<Drawable> getDrawables() {
        return this.holder.getDrawables();
    }

    @Override
    public boolean contains(@NotNull Drawable drawable) {
        return this.holder.contains(drawable);
    }

    @Override
    public Drawable getDrawableFor(@NotNull Object element) {
        return this.holder.getDrawableFor(element);
    }

    @Override
    public void addChild(@NotNull Drawable drawable) {
        this.holder.add(drawable);
    }

    @Override
    public void removeChild(@NotNull Drawable drawable) {
        this.holder.remove(drawable);
    }

    @Override
    public int compareTo(Drawable other) {
        return this.getSerialId() - other.getSerialId();
    }

    @Override
    public void refresh() {
    }

    @Override
    public void attachRenderer(@NotNull Renderer renderer) {
        this.renderers.add(renderer);
    }

    protected DrawableRegister getRegisterLocally() {
        return this.register;
    }

    protected boolean needsUpdate() {
        return this.bounds == null || this.bounds.getWidth() != this.width || this.bounds.getHeight() != this.height || !this.bounds.getCenter().equals(this.location);
    }

    protected Rectangle createBounds() {
        return Rectangle.createAround(this.getLocation(), this.getWidth(), this.getHeight());
    }

    protected DrawablesHolder<Drawable> createHolder() {
        return DrawablesHolder.create();
    }

    protected List<Renderer> initializeRendering() {
        return new LinkedList<Renderer>();
    }

    public static class DrawableRoot
    extends DrawableImpl<Object> {
        private final PaintCanvas canvas;
        private static int drawableObjectSerial = 0;
        private static final Object ROOT_MODEL_OBJECT = new Object();

        public DrawableRoot(PaintCanvas canvas, @NotNull DiagramContext context) {
            super(ROOT_MODEL_OBJECT, context);
            this.canvas = canvas;
            this.initRenderers();
        }

        public static int nextSerialId() {
            return ++drawableObjectSerial;
        }

        @Override
        public void add() {
            throw new IllegalStateException("Drawable Root cannot be added nor removed!");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Drawable Root cannot be added nor removed!");
        }

        @Override
        public DrawableRegister getRegister() {
            return this.getRegisterLocally();
        }

        @Override
        @NotNull
        public Point getLocation() {
            return Point.ORIGIN;
        }

        @Override
        @NotNull
        public Point getAbsoluteOffset() {
            return Point.ORIGIN;
        }

        @Override
        @NotNull
        public Rectangle getBounds() {
            Rectangle result = Rectangle.ZERO;
            for (Drawable child : this.getDrawables()) {
                result = result.union(child.getBounds());
            }
            return result;
        }

        public Dimension getCanvasSize() {
            Dimension result = this.canvas != null ? this.canvas.getScrollPaneViewportSize() : Dimension.ZERO;
            return result;
        }

        @Override
        public int getWidth() {
            throw new IllegalStateException("DrawableRoot");
        }

        @Override
        public int getHeight() {
            throw new IllegalStateException("DrawableRoot");
        }

        protected void initRenderers() {
            this.attachRenderer(ChildrenRenderer.createUnclipped(this));
        }
    }
}

