/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import java.awt.geom.Point2D;
import java.util.Locale;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DiagramContext {
    private int deltaX;
    private int deltaY;
    private boolean drawableBounds = false;
    private boolean drawableDebug = false;
    private boolean drawableRedrawRegions = false;
    private FontMetrics fontMetrics;
    private Graphics graphics;
    private Locale locale = Locale.getDefault();
    private Rectangle rectangle;
    private float scale = DEFAULT_SCALE;
    private boolean showGrid = false;
    private int startX;
    private int startY;
    public static float DEFAULT_SCALE = 1.0f;

    public void setLocale(Locale l) {
        this.locale = l;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isDrawableDebug() {
        return this.drawableDebug;
    }

    public void toggleDrawableDebug() {
        this.drawableDebug = !this.drawableDebug;
    }

    public boolean isDrawableRedrawRegions() {
        return this.drawableRedrawRegions;
    }

    public void toggleDrawableRedrawRegions() {
        this.drawableRedrawRegions = !this.drawableRedrawRegions;
    }

    public boolean isDrawableBounds() {
        return this.drawableBounds;
    }

    public void toggleDrawableBounds() {
        this.drawableBounds = !this.drawableBounds;
    }

    public void setGraphics(Graphics g) {
        this.graphics = g;
        if (g != null && !g.isDisposed()) {
            this.fontMetrics = g.getFontMetrics();
        }
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public void setScale(float scale) {
        assert (scale > 0.0f) : "Scale cannot be 0 or negative";
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public int scale(int value) {
        return this.isDefaultScale() ? value : Math.round((float)value * this.getScale());
    }

    public int scale(double value) {
        return (int)Math.round(this.isDefaultScale() ? value : value * (double)this.getScale());
    }

    public Point scale(Point point) {
        return this.isDefaultScale() ? point : point.scaled(this.getScale());
    }

    public Dimension scale(Dimension dimension) {
        return this.isDefaultScale() ? dimension : dimension.scaled(this.getScale());
    }

    public Rectangle scale(Rectangle rectangle) {
        return this.isDefaultScale() ? rectangle : rectangle.scaled(this.getScale());
    }

    public Font scale(Font font) {
        return this.isDefaultScale() ? font : font.scale(this.getScale());
    }

    public int unscale(int value) {
        return this.isDefaultScale() ? value : Math.round((float)value / this.getScale());
    }

    public Point unscale(int x, int y) {
        return this.isDefaultScale() ? new Point(x, y) : new Point(Math.round((float)x / this.getScale()), Math.round((float)y / this.getScale()));
    }

    public int unscale(double value) {
        return (int)Math.round(this.isDefaultScale() ? value : value / (double)this.getScale());
    }

    public Point unscale(Point point) {
        return this.isDefaultScale() ? point : point.unscaled(this.getScale());
    }

    public Rectangle unscale(Rectangle rectangle) {
        return this.isDefaultScale() ? rectangle : rectangle.unscaled(this.getScale());
    }

    public Point unscale(Point2D point) {
        return this.unscale(new Point(point));
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public void setDeltaY(int value) {
        this.deltaY = value;
    }

    public void setDeltaX(int value) {
        this.deltaX = value;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public Rectangle getRectangle() {
        Graphics graphics;
        Rectangle result = null;
        if (this.rectangle != null) {
            result = this.rectangle;
        }
        if ((graphics = this.getGraphics()) != null && graphics.getClipBounds() != null) {
            result = graphics.getClipBounds();
        }
        return result;
    }

    public void setStartX(int x) {
        this.startX = x;
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartY(int y) {
        this.startY = y;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setAntialiasing(@NotNull AntialiasingMode mode) {
        this.getGraphics().setAntialiasing(mode);
    }

    public void setTextAntialiasing(@NotNull AntialiasingMode mode) {
        this.getGraphics().setTextAntialiasing(mode);
    }

    private boolean isDefaultScale() {
        return this.getScale() == DEFAULT_SCALE;
    }
}

