/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.project.catalog.parser.wsdl.Import;
import oracle.bpm.project.catalog.parser.wsdl.Message;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xsd.SchemaElementFactory;
import oracle.bpm.project.model.processes.conversation.Conversation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WsdlBuilderContext {
    final Map<String, Message> messages = new HashMap<String, Message>();
    final Map<Element, Map<String, Operation>> operationsByPortTypeName = new HashMap<Element, Map<String, Operation>>();
    final Map<String, DefaultElement> portTypes = new HashMap<String, DefaultElement>();
    final List<oracle.bpm.project.catalog.parser.xsd.Import> schemaImports = new ArrayList<oracle.bpm.project.catalog.parser.xsd.Import>();
    final List<Import> wsdlImports = new ArrayList<Import>();
    private Map<String, String> callBackNameByPortType = new HashMap<String, String>();
    private Map<String, Element> definedElements = new HashMap<String, Element>();
    private Map<String, Conversation> unusedConversations = new HashMap<String, Conversation>();

    private WsdlBuilderContext() {
    }

    public static WsdlBuilderContext create() {
        return new WsdlBuilderContext();
    }

    public Collection<Conversation> getUnusedConversations() {
        return this.unusedConversations.values();
    }

    public void markConversation(@NotNull String conversationId) {
        this.unusedConversations.remove(conversationId);
    }

    public void createWsdlImportFor(@NotNull SchemaObject schemaObject) {
        String location = this.fixLocationPath(schemaObject);
        String namespace = schemaObject.getNamespace();
        Import anImport = WsdlElementFactory.createImport((String)namespace, (String)location, null);
        this.wsdlImports.add(anImport);
    }

    @NotNull
    public List<Import> getWsdlImports() {
        return this.wsdlImports;
    }

    public void createchemalImportFor(@NotNull SchemaObject schemaObject) {
        String location = this.fixLocationPath(schemaObject);
        String namespace = schemaObject.getNamespace();
        oracle.bpm.project.catalog.parser.xsd.Import importElement = SchemaElementFactory.createImport((String)namespace, (String)location);
        this.schemaImports.add(importElement);
    }

    @NotNull
    public List<oracle.bpm.project.catalog.parser.xsd.Import> getSchemaImports() {
        return this.schemaImports;
    }

    public Collection<Message> getMessages() {
        return this.messages.values();
    }

    public void addMessage(@NotNull String messageName, @NotNull Message message) {
        this.messages.put(messageName, message);
    }

    @Nullable
    public Message getMessage(@NotNull String messageName) {
        return this.messages.get(messageName);
    }

    public Collection<DefaultElement> getPortTypes() {
        return this.portTypes.values();
    }

    public void addPortType(@NotNull String portTypeName, @NotNull DefaultElement portType) {
        this.portTypes.put(portTypeName, portType);
    }

    @Nullable
    public DefaultElement getPortType(@NotNull String portTypeName) {
        return this.portTypes.get(portTypeName);
    }

    public void addDefinedElement(@NotNull String elementName, @NotNull Element element) {
        this.definedElements.put(elementName, element);
    }

    public Collection<Element> getDefinedElements() {
        return this.definedElements.values();
    }

    @NotNull
    public Map<String, Operation> getOperationFromPortType(@NotNull Element portType) {
        Map<String, Operation> operations = this.operationsByPortTypeName.get(portType);
        if (operations == null) {
            operations = new HashMap<String, Operation>();
            this.operationsByPortTypeName.put(portType, operations);
        }
        return operations;
    }

    public void setHasCallBackPorType(@NotNull String portTypeName, @NotNull String portTypeCallBackName) {
        this.callBackNameByPortType.put(portTypeName, portTypeCallBackName);
    }

    @Nullable
    public String getCallBackPortTypeName(@NotNull String portTypeName) {
        return this.callBackNameByPortType.get(portTypeName);
    }

    public void addUnusedConversation(@NotNull Conversation conversation) {
        this.unusedConversations.put(conversation.getId(), conversation);
    }

    private String fixLocationPath(SchemaObject schemaObject) {
        String location = schemaObject.getLocation();
        if (location != null && location.startsWith("/")) {
            location = location.substring(1);
        }
        return location;
    }
}

