/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.io.Closeable;
import java.io.IOException;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.ProjectWsdlBuilder;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;

public class ProjectWsdlWriter {
    public static final String PROJECT_PROPERTIES_WSDL = "project_properties.wsdl";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(@NotNull Project model) throws BuilderException {
        VFileSystem dataFileSystem = model.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
        VFile vFile = dataFileSystem.createFile(PROJECT_PROPERTIES_WSDL);
        VFileOutputStream outputStream = null;
        try {
            ProjectWsdlBuilder wsdlBuilder = new ProjectWsdlBuilder(model);
            String wsdlContent = wsdlBuilder.build();
            outputStream = new VFileOutputStream(vFile);
            outputStream.write(wsdlContent.getBytes("UTF-8"));
        }
        catch (IOException e) {
            try {
                throw new BuilderException(ProjectCatalogMsg.WSDL_BUILDER_ERROR, (Throwable)e);
                catch (BuilderException e2) {
                    throw new BuilderException(ProjectCatalogMsg.WSDL_BUILDER_ERROR, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(new Closeable[]{outputStream});
                throw throwable;
            }
        }
        StreamUtils.close(new Closeable[]{outputStream});
    }
}

