/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.catalog.composite.ScaController;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.ProjectWsdlWriter;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;

public class ProjectWsdlHelper {
    public static void update(@NotNull Project model) throws BuilderException {
        if (ProjectWsdlHelper.hasValidValues(model)) {
            ProjectWsdlHelper.deleteFile(model);
            ProjectWsdlHelper.removeImportFromComposite(model);
        } else {
            ProjectWsdlWriter.write(model);
            ProjectWsdlHelper.addImportToComposite(model);
        }
    }

    private static void deleteFile(Project model) {
        VFileSystem dataFileSystem = model.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
        VFile vFile = dataFileSystem.createFile("project_properties.wsdl");
        vFile.delete();
    }

    private static void removeImportFromComposite(Project model) {
        ScaController scaController = CompositeAccessorFactory.createScaController((Project)model);
        scaController.removeProjectWsdlImport();
        scaController.commitChanges();
    }

    private static void addImportToComposite(Project model) {
        ScaController scaController = CompositeAccessorFactory.createScaController((Project)model);
        if (!scaController.existsProjectWsdlImport()) {
            scaController.addProjectWsdlImport();
            scaController.commitChanges();
        }
    }

    private static boolean hasValidValues(Project model) {
        return model.getProperties().isEmpty() && model.getPropertyAliases().isEmpty();
    }
}

