/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.catalog.correlation.PropertyAlias;
import oracle.bpm.project.catalog.correlation.PropertyAliasImpl;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xmlparser.Text;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.ProcessUtil;
import oracle.bpm.project.interfaces.ProcessWsdlWriter;
import oracle.bpm.project.interfaces.WsdlBuilder;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.CorrelationPropertyAlias;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.processes.correlations.InputCorrelationsEnabled;
import oracle.bpm.project.model.processes.correlations.OutputCorrelationsEnabled;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class ProjectWsdlBuilder
extends WsdlBuilder<Project> {
    private int prefixIndex;
    private static final String VPROP = "vprop";
    private static final String TNS = "tns";

    public ProjectWsdlBuilder(@NotNull Project project) {
        super(project);
        this.wsdlContext.addNamespace(VPROP, "http://docs.oasis-open.org/wsbpel/2.0/varprop");
        this.prefixIndex = 1;
    }

    @Override
    public String build() throws BuilderException {
        return this.buildServiceDefinition().getWsdl();
    }

    @Override
    protected void doBuild(@NotNull ServiceDefinition service) throws BuilderException {
        Project project = (Project)this.getModel();
        for (CorrelationProperty prop : project.getProperties()) {
            if (prop.isReadOnly()) continue;
            this.buildProperty(service, prop);
        }
        HashSet<CorrelationPropertyAlias> cpaSet = new HashSet<CorrelationPropertyAlias>();
        HashSet<PropertyAlias> paSet = new HashSet<PropertyAlias>();
        HashSet<Process> rootsSet = new HashSet<Process>();
        for (CorrelationPropertyAlias correlationPropertyAlias : project.getPropertyAliases()) {
            if (correlationPropertyAlias.isReadOnly()) continue;
            cpaSet.add(correlationPropertyAlias);
        }
        for (Process process : project.getProcesses()) {
            Set roots;
            Sequence parents = ProcessUtil.findCallers((Process)process);
            if (process.isCallableSubprocess() && parents.isEmpty() || (roots = ProcessUtil.findRoots((Process)process)).isEmpty()) continue;
            for (Activity activity : ModelUtils.getAllActivities((Process)process)) {
                Sequence correlationItems;
                CorrelationItemsContainer cic;
                if (!(activity instanceof CorrelationsEnabled)) continue;
                CorrelationsEnabled ce = (CorrelationsEnabled)activity;
                if (ce.isInputCorrelationsEnabled()) {
                    cic = ((InputCorrelationsEnabled)ce).getInputCorrelationsContainer();
                    correlationItems = cic.getCorrelationItems();
                    this.processCorrelationItems(service, process, roots, correlationItems, cpaSet, paSet, rootsSet);
                }
                if (!ce.isOutputCorrelationsEnabled()) continue;
                cic = ((OutputCorrelationsEnabled)ce).getOutputCorrelationsContainer();
                correlationItems = cic.getCorrelationItems();
                this.processCorrelationItems(service, process, roots, correlationItems, cpaSet, paSet, rootsSet);
            }
        }
        for (CorrelationPropertyAlias correlationPropertyAlias : cpaSet) {
            this.buildPropertyAlias(service, correlationPropertyAlias);
        }
        for (PropertyAlias propertyAlias : paSet) {
            this.buildPropertyAlias(service, propertyAlias);
        }
        for (Process process : rootsSet) {
            ProcessWsdlWriter.write(process);
        }
    }

    @Override
    protected String getTargetNamespace() {
        return ((Project)this.getModel()).getProjectNamespace();
    }

    private boolean shouldCreatePropertyAliasForRoot(@NotNull CorrelationPropertyAlias propertyAlias, @NotNull CorrelationProperty prop, @NotNull Process childProcess) {
        if (!propertyAlias.getProperty().getName().equals(prop.getName())) {
            return false;
        }
        Map<String, URI> uriMap = propertyAlias.getExpression().getNamespaces();
        for (Map.Entry<String, URI> entry : uriMap.entrySet()) {
            if (!"ns".equals(entry.getKey()) || !entry.getValue().toString().equals(childProcess.getNamespace().toString())) continue;
            return true;
        }
        return false;
    }

    private void processCorrelationItems(@NotNull ServiceDefinition service, @NotNull Process process, @NotNull Collection<Process> roots, @NotNull Sequence<CorrelationItem> correlationItems, @NotNull Set<CorrelationPropertyAlias> cpaSet, Set<PropertyAlias> paSet, Set<Process> rootsSet) {
        Project project = process.getProject();
        for (CorrelationItem ci : correlationItems) {
            for (CorrelationProperty prop : ci.getCorrelationKey().getProperties()) {
                for (Process root : roots) {
                    for (CorrelationPropertyAlias propertyAlias : project.getPropertyAliases()) {
                        if (propertyAlias.isReadOnly() || !cpaSet.contains(propertyAlias) || !this.shouldCreatePropertyAliasForRoot(propertyAlias, prop, process)) continue;
                        paSet.add(this.addPropertyAlias(service, propertyAlias, prop, process, root));
                        rootsSet.add(root);
                    }
                }
            }
        }
    }

    private void buildProperty(@NotNull ServiceDefinition service, @NotNull CorrelationProperty property) {
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        attrs.put(NAME_ATTR, property.getFullName().getLocalPart());
        CatalogType type = property.getType();
        QName typeQName = type.getDelegate().asSchemaObject().getQName();
        assert (typeQName != null) : "QName cannot be null for the given type";
        NamespaceContext context = service.getNSContext();
        String prefix = this.findOrCreatePrefix(context, typeQName);
        attrs.put(TYPE_ATTR, prefix + ":" + typeQName.getLocalPart());
        Element bpwsProp = this.getWsdlElementFactory().create("http://docs.oasis-open.org/wsbpel/2.0/varprop", "property", attrs);
        service.addChild(bpwsProp);
    }

    private void buildPropertyAlias(@NotNull ServiceDefinition service, @NotNull CorrelationPropertyAlias propertyAlias) {
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        NamespaceContext context = service.getNSContext();
        QName property = propertyAlias.getProperty().getFullName();
        String propPrefix = this.findOrCreatePrefix(context, property);
        attrs.put(new QName("propertyName"), propPrefix + ":" + property.getLocalPart());
        QName element = propertyAlias.getElement();
        if (element == null) {
            QName messageType = propertyAlias.getMessageType();
            String msgPrefix = this.findOrCreatePrefix(context, messageType);
            attrs.put(new QName("messageType"), msgPrefix + ":" + messageType.getLocalPart());
            attrs.put(new QName("part"), propertyAlias.getPartName());
        } else {
            String msgPrefix = this.findOrCreatePrefix(context, element);
            attrs.put(new QName("element"), msgPrefix + ":" + element.getLocalPart());
        }
        Element bpwsPropAlias = this.getWsdlElementFactory().create("http://docs.oasis-open.org/wsbpel/2.0/varprop", "propertyAlias", attrs);
        Expression expression = propertyAlias.getExpression();
        Map<String, URI> uriMap = expression.getNamespaces();
        HashMap<QName, String> queryAttrs = new HashMap<QName, String>();
        for (Map.Entry<String, URI> entry : uriMap.entrySet()) {
            queryAttrs.put(new QName("xmlns:" + entry.getKey()), entry.getValue().toString());
        }
        Element bpwsQuery = this.getWsdlElementFactory().create("http://docs.oasis-open.org/wsbpel/2.0/varprop", "query", queryAttrs);
        bpwsQuery.addChild((Element)new Text(expression.getExpressionValue()));
        bpwsPropAlias.addChild(bpwsQuery);
        service.addChild(bpwsPropAlias);
    }

    private void buildPropertyAlias(@NotNull ServiceDefinition service, @NotNull PropertyAlias propertyAlias) {
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        NamespaceContext context = service.getNSContext();
        QName property = propertyAlias.getProperty();
        String propPrefix = this.findOrCreatePrefix(context, property);
        attrs.put(new QName("propertyName"), propPrefix + ":" + property.getLocalPart());
        QName element = propertyAlias.getElement();
        if (element == null) {
            QName messageType = propertyAlias.getMessageType();
            String msgPrefix = this.findOrCreatePrefix(context, messageType);
            attrs.put(new QName("messageType"), msgPrefix + ":" + messageType.getLocalPart());
            attrs.put(new QName("part"), propertyAlias.getPart());
        } else {
            String msgPrefix = this.findOrCreatePrefix(context, element);
            attrs.put(new QName("element"), msgPrefix + ":" + element.getLocalPart());
        }
        Element bpwsPropAlias = this.getWsdlElementFactory().create("http://docs.oasis-open.org/wsbpel/2.0/varprop", "propertyAlias", attrs);
        Expression expression = propertyAlias.getExpression();
        Map<String, URI> uriMap = expression.getNamespaces();
        HashMap<QName, String> queryAttrs = new HashMap<QName, String>();
        for (Map.Entry<String, URI> entry : uriMap.entrySet()) {
            queryAttrs.put(new QName("xmlns:" + entry.getKey()), entry.getValue().toString());
        }
        Element bpwsQuery = this.getWsdlElementFactory().create("http://docs.oasis-open.org/wsbpel/2.0/varprop", "query", queryAttrs);
        bpwsQuery.addChild((Element)new Text(expression.getExpressionValue()));
        bpwsPropAlias.addChild(bpwsQuery);
        service.addChild(bpwsPropAlias);
    }

    private PropertyAlias addPropertyAlias(@NotNull ServiceDefinition service, @NotNull CorrelationPropertyAlias propertyAlias, @NotNull CorrelationProperty prop, @NotNull Process childProcess, @NotNull Process rootProcess) {
        PropertyAliasImpl pa = new PropertyAliasImpl(propertyAlias.isReadOnly(), new QName(propertyAlias.getProperty().getFullName().getNamespaceURI(), propertyAlias.getProperty().getFullName().getLocalPart()), new QName(propertyAlias.getMessageType().getNamespaceURI(), propertyAlias.getMessageType().getLocalPart()), new String(propertyAlias.getPartName()));
        pa.setElement(propertyAlias.getElement());
        if (propertyAlias.getElement() == null) {
            pa.setMessageType(new QName(rootProcess.getNamespace(), propertyAlias.getMessageType().getLocalPart()));
        }
        Map<String, URI> uriMap = propertyAlias.getExpression().getNamespaces();
        HashMap<String, URI> revisedUriMap = new HashMap<String, URI>();
        Expression expression = propertyAlias.getExpression();
        for (Map.Entry<String, URI> entry : uriMap.entrySet()) {
            if (entry.getValue().toString().equals(childProcess.getNamespace().toString())) {
                try {
                    URI rootUri = new URI(rootProcess.getNamespace());
                    revisedUriMap.put(new String(entry.getKey()), rootUri);
                }
                catch (URISyntaxException urise) {}
                continue;
            }
            revisedUriMap.put(new String(entry.getKey()), URI.create(entry.getValue().toString()));
        }
        pa.setExpression(new String(expression.getExpressionValue()), revisedUriMap);
        return pa;
    }

    private void rebuildPropertyAlias(@NotNull ServiceDefinition service, @NotNull CorrelationPropertyAlias propertyAlias, @NotNull CorrelationProperty prop, @NotNull Process childProcess, @NotNull Process rootProcess) {
        if (!propertyAlias.getProperty().getName().equals(prop.getName())) {
            return;
        }
        Map<String, URI> uriMap = propertyAlias.getExpression().getNamespaces();
        int namespaceMatchHits = 0;
        for (Map.Entry<String, URI> entry : uriMap.entrySet()) {
            if (!entry.getValue().toString().equals(childProcess.getNamespace().toString())) continue;
            ++namespaceMatchHits;
        }
        if (namespaceMatchHits == 0) {
            return;
        }
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        NamespaceContext context = service.getNSContext();
        QName property = propertyAlias.getProperty().getFullName();
        String propPrefix = this.findOrCreatePrefix(context, property);
        attrs.put(new QName("propertyName"), propPrefix + ":" + property.getLocalPart());
        QName element = propertyAlias.getElement();
        if (element == null) {
            QName messageType = new QName(rootProcess.getNamespace(), propertyAlias.getMessageType().getLocalPart());
            String msgPrefix = this.findOrCreatePrefix(context, messageType);
            attrs.put(new QName("messageType"), msgPrefix + ":" + messageType.getLocalPart());
            attrs.put(new QName("part"), propertyAlias.getPartName());
        } else {
            String msgPrefix = this.findOrCreatePrefix(context, new QName(rootProcess.getNamespace(), element.getLocalPart()));
            attrs.put(new QName("element"), msgPrefix + ":" + element.getLocalPart());
        }
        Element bpwsPropAlias = this.getWsdlElementFactory().create("http://docs.oasis-open.org/wsbpel/2.0/varprop", "propertyAlias", attrs);
        Expression expression = propertyAlias.getExpression();
        HashMap<QName, String> queryAttrs = new HashMap<QName, String>();
        String rootPrefix = this.findOrCreatePrefix(context, rootProcess.getNamespace().toString());
        String childPrefix = "";
        for (Map.Entry<String, URI> entry : uriMap.entrySet()) {
            if (entry.getValue().toString().equals(childProcess.getNamespace().toString())) {
                queryAttrs.put(new QName("xmlns:" + entry.getKey()), rootProcess.getNamespace().toString());
                childPrefix = entry.getKey();
                continue;
            }
            queryAttrs.put(new QName("xmlns:" + entry.getKey()), entry.getValue().toString());
        }
        Element bpwsQuery = this.getWsdlElementFactory().create("http://docs.oasis-open.org/wsbpel/2.0/varprop", "query", queryAttrs);
        bpwsQuery.addChild((Element)new Text(expression.getExpressionValue()));
        bpwsPropAlias.addChild(bpwsQuery);
        service.addChild(bpwsPropAlias);
    }

    private String findOrCreatePrefix(NamespaceContext context, QName qName) {
        return this.findOrCreatePrefix(context, qName.getNamespaceURI());
    }

    private String findOrCreatePrefix(NamespaceContext context, String uri) {
        String prefix;
        Collection prefixes = context.findPrefixesByUri(uri);
        if (prefixes == null || prefixes.isEmpty()) {
            prefix = TNS + ++this.prefixIndex;
            context.addNamespace(prefix, uri);
        } else {
            prefix = (String)prefixes.iterator().next();
        }
        return prefix;
    }
}

