/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.draw.renderer.AbstractRenderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessSealType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ProcessTemplateRenderer
extends AbstractRenderer {
    private static final Image BIG_LOCK = Image.create((Msg)ProjectDrawMsg.BIG_LOCK_CLOSED).getGrayed();
    private static final int LOCK_GAP = 15;

    private ProcessTemplateRenderer(@NotNull DrawableProcess process) {
        super(process);
    }

    public static ProcessTemplateRenderer create(@NotNull DrawableProcess container) {
        return new ProcessTemplateRenderer(container);
    }

    @Override
    public void render() {
        ProcessSealType type = (ProcessSealType)this.getFeature(ProcessSealTypeFeature.class).getValue();
        if (type.isFlowSealed() && this.getProcess().getProject().isTemplate()) {
            DiagramContext context = this.getContext();
            Graphics graphics = context.getGraphics();
            Color original = graphics.getForeground();
            Dimension canvas = this.getRoot().getCanvasSize();
            if (canvas.equals(Dimension.ZERO)) {
                canvas = this.getRoot().getBounds().getSize();
            }
            Image image = BIG_LOCK;
            int deltaX = context.getDeltaX();
            int deltaY = context.getDeltaY();
            graphics.setForeground(Color.TRANSLUCENT);
            int x = deltaX + canvas.getWidth() - image.getWidth() - 15;
            int y = deltaY + 15;
            graphics.drawImage(image, x, y, image.getWidth(), image.getHeight());
            graphics.setForeground(original);
        }
    }

    @Override
    protected DrawableProcess getDrawable() {
        return (DrawableProcess)super.getDrawable();
    }

    private DrawableImpl.DrawableRoot getRoot() {
        Drawable parent = this.getDrawable().getContainer();
        while (!(parent instanceof DrawableImpl.DrawableRoot)) {
            parent = parent.getContainer();
        }
        return (DrawableImpl.DrawableRoot)parent;
    }

    private <T extends Feature> T getFeature(Class<T> featureClass) {
        return (T)this.getProcess().getFeature(featureClass);
    }

    private Process getProcess() {
        return (Process)this.getDrawable().getModelObject();
    }
}

