/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.collections.Sequence;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.renderer.AbstractRenderer;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ProcessPoolRenderer
extends AbstractRenderer {
    private int lastHeight = 0;
    private int lastProcessHeight = 0;

    private ProcessPoolRenderer(@NotNull DrawableProcess process) {
        super(process);
    }

    public static Renderer create(DrawableProcess drawable) {
        return new ProcessPoolRenderer(drawable);
    }

    @Override
    public void render() {
        Rectangle bounds = this.getContext().scale(this.getBounds());
        Graphics graphics = this.getContext().getGraphics();
        Color original = graphics.getForeground();
        graphics.setForeground(Color.FUEGO_LIGHT_BLUE);
        graphics.fillRoundRect(bounds.getX(), bounds.getY(), 20000, bounds.getHeight(), 12, 12);
        graphics.setForeground(original);
    }

    @Override
    protected DrawContext getContext() {
        return (DrawContext)super.getContext();
    }

    @Override
    protected DrawableProcess getDrawable() {
        return (DrawableProcess)super.getDrawable();
    }

    private Rectangle getBounds() {
        DrawableProcess process = this.getDrawable();
        if (process.getHeight() != this.lastProcessHeight) {
            Sequence<DrawableFlowElement> lanes = process.getDrawablesAt(DesignerLayer.LANE_NAME);
            int totalHeight = 0;
            for (DrawableFlowElement drawableFlowElement : lanes) {
                totalHeight += drawableFlowElement.getBounds().getHeight();
            }
            this.lastHeight = totalHeight;
            this.lastProcessHeight = process.getHeight();
        }
        Rectangle original = process.getBounds();
        Rectangle shrinked = original.shrink(process.getInsets());
        return Rectangle.valueOf(shrinked.getOrigin().sub(24, 12), shrinked.getWidth(), this.lastHeight + 24);
    }
}

