/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.figure;

import java.util.EnumMap;
import oracle.bpm.collections.maps.EnumTupleMap;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.IsInterruptingFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.notification.NotificationType;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class FlowFigureUtils {
    private static final EnumMap<BpmnType, FlowFigureType> TYPE_TO_FIGURE = new EnumMap(BpmnType.class);
    private static final EnumTupleMap<EventTriggerType, BpmnType, FlowFigureType> TRIGGER_TO_FIGURE = new EnumTupleMap(EventTriggerType.class, BpmnType.class);
    private static final EnumTupleMap<EventTriggerType, BpmnType, FlowFigureType> TRIGGER_TO_FIGURE_NON_INTERRUPTING = new EnumTupleMap(EventTriggerType.class, BpmnType.class);
    private static final EnumTupleMap<MeasurementType, BpmnType, FlowFigureType> MEASUREMENT_TO_FIGURE = new EnumTupleMap(MeasurementType.class, BpmnType.class);
    private static final EnumTupleMap<GatewayDirection, BpmnType, FlowFigureType> DIRECTION_TO_FIGURE = new EnumTupleMap(GatewayDirection.class, BpmnType.class);
    private static final EnumMap<HumanTaskType, FlowFigureType> HUMAN_TASK_TO_FIGURE = new EnumMap(HumanTaskType.class);
    private static final EnumMap<NotificationType, FlowFigureType> NOTIFICATION_TO_FIGURE = new EnumMap(NotificationType.class);

    @NotNull
    public static FlowFigureType fromElement(@NotNull FlowElement element) {
        FlowFigureType result = null;
        if (element instanceof FlowNode) {
            FlowNode node = (FlowNode)element;
            if (node.isEvent()) {
                boolean applies;
                BooleanFeature interrupt = (BooleanFeature)node.getFeature(IsInterruptingFeature.class);
                boolean bl = applies = node.getBpmnType() == BpmnType.BOUNDARY_EVENT || node.getBpmnType() == BpmnType.START_EVENT && ModelUtils.isEventSubprocess((FlowNode)node.getSubprocess());
                if (applies && interrupt != null && !interrupt.getValue().booleanValue()) {
                    result = FlowFigureUtils.fromNonInterruptingEvent(node);
                } else {
                    if (FlowFigureUtils.hasError(node)) {
                        Event event = (Event)node.asAnyNode(Event.class);
                        if (event.isEnd() && event.getEventTriggerType() == EventTriggerType.MESSAGE) {
                            result = FlowFigureType.END_EVENT_MESSAGE_ERROR;
                        } else if (event.isThrowEvent() && event.getEventTriggerType() == EventTriggerType.MESSAGE) {
                            result = FlowFigureType.THROW_INTERMEDIATE_EVENT_MESSAGE_ERROR;
                        }
                    }
                    if (result == null) {
                        result = FlowFigureUtils.fromEvent(node);
                    }
                }
            } else if (node.isGateway() && node.getBpmnType() != BpmnType.EXCLUSIVE_GATEWAY) {
                result = FlowFigureUtils.fromGateway(node);
            } else if (node.isActivity()) {
                Activity activity = (Activity)node.asAnyNode(Activity.class);
                Subprocess subprocess = (Subprocess)activity.asAnyNode(Subprocess.class);
                if (subprocess != null && subprocess.isTriggeredByEvent()) {
                    result = FlowFigureType.EVENT_SUBPROCESS;
                }
                if (result == null) {
                    HumanTaskType humanTaskType;
                    UserTask userTask = (UserTask)activity.asAnyNode(UserTask.class);
                    if (userTask != null && (humanTaskType = userTask.getHumanTaskType()) != null) {
                        result = FlowFigureUtils.fromUserTask(humanTaskType);
                    }
                    if (result == null) {
                        NotificationTask notificationTask = (NotificationTask)activity.asAnyNode(NotificationTask.class);
                        if (notificationTask != null) {
                            NotificationType type = notificationTask.getNotificationType();
                            result = FlowFigureUtils.fromNotification(type);
                        }
                        if (result == null && activity.isSendTask() && FlowFigureUtils.hasError(node)) {
                            result = FlowFigureType.SEND_TASK_ERROR;
                        }
                    }
                }
            }
            if (result == null) {
                result = FlowFigureUtils.fromType(node.getBpmnType());
            }
        } else {
            result = element.getRawClass().equals(Measurement.class) ? FlowFigureUtils.fromMeasurement(element) : (element.getRawClass().equals(Counter.class) ? FlowFigureUtils.fromType(BpmnType.COUNTER) : FlowFigureUtils.fromType(BpmnType.NOTE));
        }
        return result;
    }

    @NotNull
    public static FlowFigureType fromType(@NotNull BpmnType type) {
        return TYPE_TO_FIGURE.get(type);
    }

    @NotNull
    public static FlowFigureType fromUserTask(@NotNull HumanTaskType task) {
        FlowFigureType result = task == HumanTaskType.SIMPLE ? FlowFigureUtils.fromType(BpmnType.USER_TASK) : HUMAN_TASK_TO_FIGURE.get(task);
        assert (result != null) : "Invalid arguments : Not a valid HumanTaskType " + task;
        return result;
    }

    @NotNull
    public static FlowFigureType fromEvent(@NotNull BpmnType event, @NotNull EventTriggerType trigger) {
        FlowFigureType result = trigger != EventTriggerType.NONE ? TRIGGER_TO_FIGURE.get(trigger, event) : FlowFigureUtils.fromType(event);
        assert (result != null) : "Invalid arguments : Not a valid combination of Event " + event + " and Trigger " + trigger;
        return result;
    }

    @NotNull
    public static FlowFigureType fromGateway(@NotNull BpmnType gateway, @NotNull GatewayDirection direction) {
        FlowFigureType result = DIRECTION_TO_FIGURE.get(direction, gateway);
        assert (result != null) : "Invalid arguments : Not a valid combination of Gateway " + gateway + " and Direction " + direction;
        return result;
    }

    @NotNull
    public static FlowElement createArtifactFromFigureType(@NotNull FlowFigureType figureType, @NotNull NodeContainer container) {
        Measurement result = null;
        if (figureType.getType() == BpmnType.MEASUREMENT) {
            String id = ModelUtils.nextNameForMeasurement((Process)container.getProcess(), (String)CoreMsg.MEASUREMENT.getString());
            result = container.createMeasurement(id);
        } else if (figureType == FlowFigureType.COUNTER) {
            String id = ModelUtils.nextNameForCounter((Process)container.getProcess(), (String)CoreMsg.COUNTER.getString());
            result = container.createCounter(id);
        } else if (figureType == FlowFigureType.NOTE) {
            String id = ModelUtils.nextNameForNote((Process)container.getProcess(), (String)CoreMsg.NOTE.getString());
            result = container.createTextAnnotation(id);
        }
        if (result == null) {
            throw new IllegalStateException("Cannot create artifact for given FlowFigureType: " + figureType);
        }
        return result;
    }

    @NotNull
    public static FlowNode createNodeFromFigureType(@NotNull FlowFigureType figureType, @NotNull NodeContainer container) {
        Object result = figureType.getType().isEvent() ? FlowFigureUtils.createEventFromFigureType(figureType, container) : (figureType.getType().isGateway() ? FlowFigureUtils.createGatewayFromFigureType(figureType, container) : FlowFigureUtils.createActivityFromFigureType(figureType, container));
        return result;
    }

    @NotNull
    public static BoundaryEvent createBoundaryEventFromFigureType(@NotNull EventTriggerType trigger, @NotNull Activity boundaryTarget, @NotNull NodeContainer container) {
        BoundaryEvent event = container.createBoundaryEvent(trigger, boundaryTarget);
        event.setId(ModelUtils.nextIdFor((BpmnType)event.getBpmnType(), (FlowNode)event));
        event.setDefaultLabel(ModelUtils.generateDefaultLabel((FlowNode)event));
        return event;
    }

    public static Msg getNameForType(@NotNull FlowFigureType type) {
        Msg result = type.getTrigger() != null ? type.getTrigger().getLabel() : (type.getType().isEvent() ? ProjectModelMsg.NONE : (type.getHumanTaskType() != null ? type.getHumanTaskType().getLabel() : (type == FlowFigureType.EVENT_SUBPROCESS ? ProjectModelMsg.EVENT_SUBPROCESS : (type.getNotificationType() != null ? type.getNotificationType().getMsg() : type.getType().getShortLabel()))));
        return result;
    }

    public static Msg getDescriptionForType(@NotNull FlowFigureType type) {
        Msg creation;
        EventTriggerType trigger = type.getTrigger();
        if (trigger != null) {
            creation = ProjectDrawMsg.WITH_EVENT_TRIGGER_TYPE(type.getType().getString().toLowerCase(), trigger.getString());
        } else {
            HumanTaskType task = type.getHumanTaskType();
            NotificationType notification = type.getNotificationType();
            creation = task != null ? ProjectDrawMsg.HUMAN_TASK_OF_TYPE(task.getString()) : (notification != null ? ProjectDrawMsg.NOTIFICATION_OF_TYPE(notification.getMsg().getString()) : (type.getType().isEvent() ? ProjectDrawMsg.WITH_EVENT_TRIGGER_TYPE(type.getType().getString().toLowerCase(), CoreMsg.NONE.getString()) : (type == FlowFigureType.EVENT_SUBPROCESS ? ProjectModelMsg.EVENT_SUBPROCESS : type.getLabel())));
        }
        return ProjectDrawMsg.CREATE(creation.getString());
    }

    private static boolean hasError(@NotNull FlowNode node) {
        Conversational conversational;
        Conversation conversation;
        if (node.isConversational() && (conversation = (conversational = (Conversational)node.asAnyNode(Conversational.class)).getConversation()) != null && conversation.getConversationType() == ConversationType.DEFINE_INTERFACE) {
            DefineInterfaceConversationalDefinition conversationalDefinition = (DefineInterfaceConversationalDefinition)conversational.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
            return conversationalDefinition.getError() != null;
        }
        return false;
    }

    private static FlowFigureType fromNotification(@NotNull NotificationType type) {
        FlowFigureType result = NOTIFICATION_TO_FIGURE.get(type);
        assert (result != null) : "Invalid arguments : Not a valid NotificationType " + type;
        return result;
    }

    private static FlowFigureType fromMeasurement(FlowElement element) {
        Measurement measurement = (Measurement)element;
        MeasurementType type = measurement.getMeasurementType();
        FlowFigureType result = MEASUREMENT_TO_FIGURE.get(type, BpmnType.MEASUREMENT);
        if (result == null) {
            result = FlowFigureUtils.fromType(BpmnType.MEASUREMENT);
        }
        return result;
    }

    private static FlowFigureType fromGateway(FlowNode node) {
        FlowFigureType result = null;
        GatewayDirection direction = ((Gateway)node.asAnyNode(Gateway.class)).getDirection();
        if (direction != GatewayDirection.UNSPECIFIED) {
            result = FlowFigureUtils.fromGateway(node.getBpmnType(), direction);
        }
        return result;
    }

    private static FlowFigureType fromEvent(FlowNode node) {
        FlowFigureType result = null;
        EventTriggerType trigger = ((Event)node.asAnyNode(Event.class)).getEventTriggerType();
        if (trigger != null) {
            result = FlowFigureUtils.fromEvent(node.getBpmnType(), trigger);
        }
        return result;
    }

    private static FlowFigureType fromNonInterruptingEvent(FlowNode node) {
        FlowFigureType result = null;
        EventTriggerType trigger = ((Event)node.asAnyNode(Event.class)).getEventTriggerType();
        if (trigger != null && (result = TRIGGER_TO_FIGURE_NON_INTERRUPTING.get(trigger, node.getBpmnType())) == null) {
            result = FlowFigureUtils.fromEvent(node.getBpmnType(), trigger);
        }
        return result;
    }

    @NotNull
    private static Activity createActivityFromFigureType(@NotNull FlowFigureType figureType, @NotNull NodeContainer container) {
        Activity activity = container.createActivity();
        switch (figureType.getType()) {
            case MANUAL_TASK: {
                activity.toManualTask();
                break;
            }
            case BUSINESS_RULE_TASK: {
                activity.toBusinessRuleTask();
                break;
            }
            case SERVICE_TASK: {
                activity.toServiceTask();
                break;
            }
            case USER_TASK: {
                activity = FlowFigureUtils.createUserTask(figureType, container);
                break;
            }
            case SEND_TASK: {
                activity.toSendTask();
                break;
            }
            case RECEIVE_TASK: {
                activity.toReceiveTask();
                break;
            }
            case SCRIPT_TASK: {
                activity.toScriptTask();
                break;
            }
            case CALL_ACTIVITY: {
                activity.toCallActivity();
                break;
            }
            case SUBPROCESS: {
                activity = FlowFigureUtils.createSubprocess(figureType, container);
                break;
            }
            case NOTIFICATION_TASK: {
                activity = FlowFigureUtils.createNotificationTask(figureType, container);
                break;
            }
            case UPDATE_TASK: {
                activity = activity.toUpdateTask();
            }
        }
        return activity;
    }

    private static Activity createUserTask(@NotNull FlowFigureType figureType, @NotNull NodeContainer container) {
        Activity result = container.createActivity();
        HumanTaskType type = figureType.getHumanTaskType();
        UserTask userTask = result.toUserTask();
        userTask.setHumanTaskType(type);
        return result;
    }

    private static Activity createNotificationTask(@NotNull FlowFigureType figureType, @NotNull NodeContainer container) {
        Activity activity = container.createActivity();
        NotificationType notificationType = figureType.getNotificationType();
        NotificationTask result = activity.toNotificationTask();
        if (notificationType != null) {
            result.setNotificationType(notificationType);
        }
        return result;
    }

    @NotNull
    private static Gateway createGatewayFromFigureType(@NotNull FlowFigureType figureType, @NotNull NodeContainer container) {
        ParallelGateway gateway = null;
        switch (figureType.getType()) {
            case PARALLEL_GATEWAY: {
                gateway = container.createParallelGateway();
                break;
            }
            case EXCLUSIVE_GATEWAY: {
                gateway = container.createExclusiveGateway();
                break;
            }
            case INCLUSIVE_GATEWAY: {
                gateway = container.createInclusiveGateway();
                break;
            }
            case EVENT_BASED_GATEWAY: {
                gateway = container.createEventBasedGateway();
                break;
            }
            case COMPLEX_GATEWAY: {
                gateway = container.createComplexGateway();
            }
        }
        if (figureType.getDirection() != null) {
            gateway.setDirection(figureType.getDirection());
        }
        return gateway;
    }

    @NotNull
    private static Event createEventFromFigureType(@NotNull FlowFigureType figureType, @NotNull NodeContainer container) {
        EndEvent event = null;
        switch (figureType.getType()) {
            case END_EVENT: {
                event = container.createEndEvent(figureType.getTrigger());
                break;
            }
            case START_EVENT: {
                event = container.createStartEvent(figureType.getTrigger());
                break;
            }
            case CATCH_INTERMEDIATE_EVENT: {
                event = container.createIntermediateCatchEvent(figureType.getTrigger());
                break;
            }
            case THROW_INTERMEDIATE_EVENT: {
                event = container.createIntermediateThrowEvent(figureType.getTrigger());
            }
        }
        return event;
    }

    private static Subprocess createSubprocess(@NotNull FlowFigureType figureType, @NotNull NodeContainer container) {
        boolean isTriggered = figureType == FlowFigureType.EVENT_SUBPROCESS;
        Subprocess subproc = container.createSubprocess(isTriggered);
        subproc.setWidth(isTriggered ? 150 : 200);
        subproc.setHeight(isTriggered ? 150 : 200);
        subproc.setDefaultLabel(ModelUtils.nextLabelForActivity((NodeContainer)container, (String)figureType.getType().getString()));
        return subproc;
    }

    static {
        for (FlowFigureType figureType : FlowFigureType.getPlainTypes()) {
            TYPE_TO_FIGURE.put(figureType.getType(), figureType);
        }
        for (FlowFigureType figureType : FlowFigureType.getArtifactTypes()) {
            TYPE_TO_FIGURE.put(figureType.getType(), figureType);
        }
        for (FlowFigureType figureType : FlowFigureType.getMeasurementTypes()) {
            MEASUREMENT_TO_FIGURE.put(figureType.getMeasurementType(), figureType.getType(), figureType);
        }
        for (FlowFigureType figureType : FlowFigureType.getTriggeredEvents()) {
            TRIGGER_TO_FIGURE.put(figureType.getTrigger(), figureType.getType(), figureType);
        }
        for (FlowFigureType figureType : FlowFigureType.getTriggeredNonInterruptingEvents()) {
            TRIGGER_TO_FIGURE_NON_INTERRUPTING.put(figureType.getTrigger(), figureType.getType(), figureType);
        }
        for (FlowFigureType figureType : FlowFigureType.getDirectedGateways()) {
            DIRECTION_TO_FIGURE.put(figureType.getDirection(), figureType.getType(), figureType);
        }
        for (FlowFigureType figureType : FlowFigureType.getHumanTaskTypes()) {
            HUMAN_TASK_TO_FIGURE.put(figureType.getHumanTaskType(), figureType);
        }
        for (FlowFigureType figureType : FlowFigureType.getNotificationTypes()) {
            NOTIFICATION_TO_FIGURE.put(figureType.getNotificationType(), figureType);
        }
    }
}

