/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.debug;

import oracle.bpm.collections.lists.StringList;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.debug.Debuggable;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.extensionpoint.metadata.DebuggableMetadata;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

@DebuggableMetadata
public class SequenceFlowDebuggable
extends Debuggable.Default
implements Debuggable.LocatedDebuggable,
Debuggable.ColoredDebuggable {
    @Override
    public void attachDebugInfo(@NotNull Drawable original, @NotNull StringList info) {
        DrawableSequenceFlow drawable = (DrawableSequenceFlow)original;
        this.attachKeyValue(info, "from", drawable.getFromLocation().toString());
        this.attachKeyValue(info, "to", drawable.getToLocation().toString());
        this.attachKeyValue(info, "control", !this.hasControlPoint(drawable) ? "??" : drawable.getControlPoint().toString());
    }

    @Override
    public boolean accepts(@NotNull Drawable drawable) {
        return drawable instanceof DrawableSequenceFlow;
    }

    @Override
    @NotNull
    public Point getSpecificLocation(@NotNull Drawable drawable) {
        DrawableSequenceFlow sequenceFlow = (DrawableSequenceFlow)drawable;
        Point result = sequenceFlow.getControlPoint();
        if (!this.hasControlPoint(sequenceFlow)) {
            result = Point.avg(sequenceFlow.getFromLocation(), sequenceFlow.getToLocation());
        }
        return result;
    }

    @Override
    @NotNull
    public Color getSpecificColor(@NotNull Drawable drawable) {
        return Color.valueOf((int)230, (int)170, (int)0, (int)200);
    }

    private boolean hasControlPoint(@NotNull DrawableSequenceFlow drawable) {
        return !drawable.getControlPoint().equals(SequenceFlow.NULL_CONTROL_POINT);
    }
}

