/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.debug;

import java.util.Map;
import java.util.NavigableMap;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.debug.DebugableDrawer;
import oracle.bpm.diagram.draw.debug.Debuggable;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.extensionpoint.metadata.DebuggableMetadata;
import oracle.bpm.geom.Point;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

@DebuggableMetadata
public class ProcessDebuggable
extends Debuggable.Default {
    @Override
    public void attachDebugInfo(@NotNull Drawable drawable, @NotNull StringList info) {
        DrawableProcess drawableProcess = (DrawableProcess)drawable;
        this.drawLanesInfo((Process)drawableProcess.getModelObject(), drawable.getContext());
    }

    @Override
    public boolean accepts(@NotNull Drawable drawable) {
        return drawable instanceof DrawableProcess;
    }

    private void drawLanesInfo(@NotNull Process process, @NotNull DiagramContext context) {
        NavigableMap lanes = ((ProcessContent)process).getLanesInternal();
        StringList result = StringList.create(lanes.size());
        for (Map.Entry entry : lanes.entrySet()) {
            Lane lane = (Lane)entry.getValue();
            result.add("[" + entry.getKey() + "] > {" + lane.getOffset() + "," + lane.getSize() + "} " + lane.getRole());
        }
        Point location = new Point(450 + context.getDeltaX(), 50 + context.getDeltaY());
        DebugableDrawer.drawList(context, result, location, Color.valueOf((int)65, (int)105, (int)160, (int)150));
    }
}

