/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.collaboration;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.collaboration.CollaborationAnchorImpl;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.collaboration.CollaborationEntity;
import oracle.bpm.project.model.collaboration.CollaborationMessage;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCollaborationEntity
extends ProjectObjectImpl
implements CollaborationEntity {
    private final Map<ProjectObject, CollaborationAnchorImpl> anchors = new HashMap<ProjectObject, CollaborationAnchorImpl>();
    private final List<CollaborationMessage> incoming = new LinkedList<CollaborationMessage>();
    private final List<CollaborationMessage> outgoing = new LinkedList<CollaborationMessage>();
    private boolean principal;

    protected AbstractCollaborationEntity(Project project) {
        super(project);
    }

    public CollaborationAnchorImpl getAnchor(@NotNull ProjectObject element) {
        return this.anchors.get(element);
    }

    public Sequence<CollaborationMessage> getOutgoingMessages() {
        return CollectionUtils.asSequence(this.outgoing);
    }

    public Sequence<CollaborationMessage> getIncomingMessages() {
        return CollectionUtils.asSequence(this.incoming);
    }

    public boolean isPrincipal() {
        return this.principal;
    }

    public void setPrincipal(boolean principal) {
        this.principal = principal;
    }

    public Class<? extends ProjectObject> getRawClass() {
        return CollaborationEntity.class;
    }

    CollaborationAnchorImpl putAnchor(@NotNull ProjectObject element) {
        CollaborationAnchorImpl anchor = CollaborationAnchorImpl.create(this, element);
        this.anchors.put(anchor.getElement(), anchor);
        return anchor;
    }

    void addOutgoingMessage(CollaborationMessage message) {
        this.outgoing.add(message);
    }

    void addIncomingMessage(CollaborationMessage message) {
        this.incoming.add(message);
    }
}

