/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.collections.Sequence;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class DrawableTriggerType
extends DrawableImpl<Activity> {
    private Rectangle cache = Rectangle.ZERO;
    private EventTriggerType lastTriggerType;
    private static final int DISTANCE_GAP = 0;

    public DrawableTriggerType(@NotNull DrawableFlowNode<Activity> container) {
        super(container, container.getModelObject(), DesignerLayer.CAPABILITY);
    }

    public static void appendTo(@NotNull DrawableFlowNode container) {
        if (DrawableTriggerType.applies(container)) {
            new DrawableTriggerType(container).add();
        }
    }

    public static boolean applies(@NotNull DrawableFlowNode controller) {
        return controller.getModelObject() instanceof Subprocess;
    }

    @Override
    public void draw() {
        Image image = this.getCurrentImage();
        if (image != null) {
            DiagramContext context = this.getContext();
            Rectangle scaled = context.scale(this.getBounds());
            Graphics graphics = context.getGraphics();
            Color original = graphics.getForeground();
            graphics.setForeground(Color.TRANSLUCENT);
            graphics.drawImage(image, scaled);
            graphics.setForeground(original);
        }
    }

    @Override
    protected Rectangle createBounds() {
        this.setupWidthHeightAndLocation();
        return super.createBounds();
    }

    @Override
    protected boolean needsUpdate() {
        boolean result = super.needsUpdate();
        boolean bl = result = result || !this.cache.equals(this.getContainer().getBounds());
        if (!result) {
            Activity activity = (Activity)this.getModelObject();
            Sequence starts = activity.getChildrenByType(StartEvent.class);
            EventTriggerType trigger = null;
            for (StartEvent start : starts) {
                EventTriggerType triggerType = start.getEventTriggerType();
                if (triggerType == EventTriggerType.NONE) continue;
                trigger = start.getEventTriggerType();
            }
            if (this.lastTriggerType != trigger) {
                result = true;
            }
        }
        return result;
    }

    private Image getCurrentImage() {
        Image result = null;
        Activity activity = (Activity)this.getModelObject();
        Sequence starts = activity.getChildrenByType(StartEvent.class);
        for (StartEvent start : starts) {
            EventTriggerType triggerType = start.getEventTriggerType();
            if (triggerType == EventTriggerType.NONE) continue;
            result = DefaultTheme.getDefault().getImageFor((FlowElement)start, ImageType.ICON);
        }
        return result;
    }

    private void setupWidthHeightAndLocation() {
        Rectangle parent = this.getContainer().getBounds();
        Image image = this.getCurrentImage();
        if (image != null) {
            this.locateAtCenterWithLeftDelta(parent, image);
        }
        this.cache = parent;
        Activity activity = (Activity)this.getModelObject();
        Sequence starts = activity.getChildrenByType(StartEvent.class);
        for (StartEvent start : starts) {
            EventTriggerType triggerType = start.getEventTriggerType();
            if (triggerType == EventTriggerType.NONE) continue;
            this.lastTriggerType = start.getEventTriggerType();
        }
    }

    private void locateAtCenterWithLeftDelta(@NotNull Rectangle parent, @NotNull Image image) {
        this.setWidth(image.getWidth());
        this.setHeight(image.getHeight());
        int dx = this.getWidth() + 0;
        int dy = this.getHeight() / 2 + 0;
        this.setLocation(new Point(parent.getWidth() / 2, parent.getHeight() / 2).translate(-dx, -dy));
    }
}

