/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.util.Locale;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableSingleLineLabel;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class DrawableSequenceFlowLabel
extends DrawableSingleLineLabel<SequenceFlow> {
    private DrawableSequenceFlowLabel(@NotNull Drawable container, @NotNull DrawableSequenceFlow owner) {
        super(container, owner);
    }

    public static DrawableSequenceFlowLabel create(@NotNull Drawable container, @NotNull DrawableSequenceFlow owner) {
        return new DrawableSequenceFlowLabel(container, owner);
    }

    @Override
    @NotNull
    public DrawContext getContext() {
        return (DrawContext)super.getContext();
    }

    @Override
    @NotNull
    public String getLabel() {
        Locale locale = this.getContext().getLocale();
        SequenceFlow sequenceFlow = (SequenceFlow)this.getModelObject();
        String label = null;
        switch (this.getContext().getTransitionMessageType()) {
            case NAME: {
                if (locale != null) {
                    label = sequenceFlow.getLabel(locale);
                }
                if (!Str.isEmpty(label)) break;
                label = sequenceFlow.getDefaultLabel();
                break;
            }
            case DESCRIPTION: {
                if (locale != null) {
                    label = sequenceFlow.getDescriptionMap().getString(locale);
                }
                if (!Str.isEmpty(label)) break;
                label = sequenceFlow.getDefaultDescription();
                break;
            }
            case CONDITION: {
                if (!sequenceFlow.isConditionalFlow()) break;
                ConditionalFlow conditionalFlow = sequenceFlow.asConditionalFlow();
                label = conditionalFlow.getCondition().getExpressionValue();
            }
        }
        return label != null ? label : "";
    }

    @Override
    public Font getFont() {
        return this.getContext().getTheme().getActivityFont(this.getOwner().isShowSelection());
    }

    protected DrawableSequenceFlow getOwner() {
        return (DrawableSequenceFlow)super.getOwner();
    }

    @Override
    protected Color getLabelTextColor() {
        return Color.DARK_GRAY;
    }

    @Override
    protected Point getCenterLocationWithoutAlignment() {
        return new Point(this.getOwner().getPathPoint(0.5));
    }
}

