/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import oracle.bpm.adapter.DefaultAdaptable;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableConnectionImpl;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.diagram.draw.DrawableLabelable;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableSequenceFlowLabel;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Elbow;
import oracle.bpm.geom.Line;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.QuadCurve;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.util.LoggingUtils;
import org.jetbrains.annotations.NotNull;

public class DrawableSequenceFlow
extends DrawableConnectionImpl<SequenceFlow>
implements DrawableFlowElement<SequenceFlow>,
DrawableLabelable {
    private Color color = Color.BLACK;
    private static final int RHOMB_LENGTH = 18;
    private static final int RHOMB_WIDTH = 5;
    private static final Color RHOMB_FILL_NORMAL = Color.FUEGO_LIGHT_BLUE;
    private static final int SLASH_SEPARATION = 9;
    private static final int SLASH_LENGTH = 6;

    protected DrawableSequenceFlow(@NotNull DrawableNodeContainer container, @NotNull SequenceFlow sequenceFlow) {
        super(container, sequenceFlow, DesignerLayer.TRANSITION);
    }

    @Override
    @NotNull
    public DrawableNodeContainer getContainer() {
        return (DrawableNodeContainer)super.getContainer();
    }

    @NotNull
    public FlowNode getFrom() {
        return ((SequenceFlow)this.getModelObject()).getSource();
    }

    @NotNull
    public FlowNode getTo() {
        return ((SequenceFlow)this.getModelObject()).getTarget();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public int getRightBound() {
        return 0;
    }

    @Override
    public int getUnderBound() {
        return 0;
    }

    @Override
    public DrawableLabel getLabel() {
        return super.getLabel();
    }

    @Override
    @NotNull
    public oracle.bpm.geom.Rectangle getBounds() {
        return AwtConverter.fromAwt((Rectangle)this.getPath().getBounds());
    }

    @Override
    @NotNull
    public Point getControlPoint() {
        Point point = ((SequenceFlow)this.getModelObject()).getControlPoint();
        return point.equals(SequenceFlow.NULL_CONTROL_POINT) ? point : this.getContext().scale(point);
    }

    public Point getToLocation() {
        return this.getTo().getLocation();
    }

    public Point getFromLocation() {
        return this.getFrom().getLocation();
    }

    @Override
    public void refresh() {
        SequenceFlow sequence = (SequenceFlow)this.getModelObject();
        this.source.setDrawable(this.getContainer().asDrawable((FlowElement)sequence.getSource()));
        this.target.setDrawable(this.getContainer().asDrawable((FlowElement)sequence.getTarget()));
        this.control.setLocation(sequence.getControlPoint());
        if (sequence.getRoutingMode() != RoutingMode.STRAIGHT && sequence.getControlPoint().equals(SequenceFlow.NULL_CONTROL_POINT)) {
            LoggingUtils.assertLog("DrawableSequenceFlow.setup", "SequenceFlow " + this.getModelObject() + " not defined as straight with Null Control Point!");
            LoggingUtils.assertDumpStack();
        }
        super.refresh();
    }

    @Override
    public <T> T as(Class<T> targetType) {
        return DefaultAdaptable.create(this.getModelObject()).as(targetType);
    }

    @Override
    @NotNull
    public DrawContext getContext() {
        return (DrawContext)super.getContext();
    }

    @Override
    protected DrawableLabel<SequenceFlow> createConnectionLabel() {
        return DrawableSequenceFlowLabel.create((Drawable)this.getContainer(), this);
    }

    @Override
    protected Path createRawPath(@NotNull Point begin, @NotNull Point end) {
        SequenceFlow flow = (SequenceFlow)this.getModelObject();
        return flow.getRoutingMode() == RoutingMode.STRAIGHT || this.control.isNull() ? new Line(begin, end) : (flow.getRoutingMode() == RoutingMode.ORTHOGONAL ? new Elbow(begin, this.control.getRawLocation(), end) : new QuadCurve(begin, this.control.getRawLocation(), end));
    }

    @Override
    protected void drawOtherDecorations(@NotNull Path path) {
        super.drawOtherDecorations(path);
        FlowNode from = this.getFrom();
        if (!ModelUtils.isEndEvent((FlowNode)from)) {
            this.drawConditionDecorators(path);
        }
    }

    @Override
    protected void drawPath(@NotNull Path path) {
        DrawContext context = this.getContext();
        Graphics graphics = context.getGraphics();
        Stroke s = graphics.getStroke();
        Color c = graphics.getForeground();
        Path scaled = path.scaled(context.getScale());
        boolean highlighted = context.isHighlighted((SequenceFlow)this.getModelObject());
        graphics.setForeground(this.getColor());
        if (highlighted) {
            graphics.setStroke(Stroke.FOUR_SOLID);
            graphics.setForeground(Color.DARK_GREEN);
        }
        if (this.isShowSelection()) {
            graphics.setStroke(Stroke.TWO_SOLID);
        }
        graphics.draw((Shape)scaled);
        if (!highlighted || !this.isShowSelection()) {
            graphics.setStroke(s);
        }
        this.drawArrow(scaled);
        if (highlighted) {
            graphics.setStroke(Stroke.ONE_SOLID);
            graphics.setForeground(Color.BLACK);
            graphics.draw((Shape)scaled);
            graphics.setForeground(Color.BLACK);
            this.drawArrow(scaled);
        }
        if (highlighted || this.isShowSelection()) {
            graphics.setStroke(s);
        }
        graphics.setForeground(c);
        this.drawOtherDecorations(scaled);
    }

    private void drawConditionDecorators(@NotNull Path path) {
        FlowNode from = this.getFrom();
        if (((SequenceFlow)this.getModelObject()).isConditionalFlow()) {
            if (!from.isGateway()) {
                this.drawRhomb(path, RHOMB_FILL_NORMAL);
            }
        } else if (from.isGateway() && !from.getOutgoingConditionalFlows().isEmpty()) {
            this.drawSlash(path);
        }
    }

    private void drawRhomb(@NotNull Path path, @NotNull Color fill) {
        DrawContext context = this.getContext();
        Point2D basePoint = this.getPathPoint(path, 0.0);
        Point2D endPoint = path.findPoint(basePoint, context.scale(18), 0.0);
        context.getGraphics().drawRhomb(basePoint.getX(), basePoint.getY(), endPoint.getX(), endPoint.getY(), context.scale(5), fill);
    }

    private void drawSlash(@NotNull Path path) {
        DrawContext context = this.getContext();
        Point2D p1 = this.getPathPoint(path, 0.0);
        Point2D point = path.findPoint(p1, context.scale(9), 0.0);
        int w = context.scale(6);
        double x = point.getX();
        double y = point.getY();
        double slope = Point.angle(p1.getX(), -p1.getY(), x, -y) - 0.7853981633974483;
        double dx = (double)w * Math.cos(slope);
        double dy = (double)w * Math.sin(slope);
        context.getGraphics().drawLine((int)Math.round(x + dx), (int)Math.round(y - dy), (int)Math.round(x - dx), (int)Math.round(y + dy));
    }
}

