/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.collections.Predicate;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableNodeContainerImpl;
import oracle.bpm.draw.DrawablePoolLabel;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableProcess
extends DrawableNodeContainerImpl<Process> {
    private Insets insets = Insets.EMPTY;
    private DrawablePoolLabel name = new DrawablePoolLabel((Drawable)this, this);
    private static final Predicate<Drawable> NOT_HIDDEN_PREDICATE = new Predicate<Drawable>(){

        @Override
        public boolean check(@Nullable Drawable drawable) {
            return drawable != null && !drawable.isHidden() && !DesignerLayer.LABEL.equals((Object)drawable.getLayer());
        }
    };
    public static final int POOL_OFFSET = 24;

    public DrawableProcess(@NotNull Drawable root, @NotNull Process process) {
        super(root, process, DesignerLayer.PROCESS);
    }

    @Override
    @NotNull
    public Point getLocation() {
        return Point.ORIGIN;
    }

    @Override
    public void add() {
        super.add();
        this.name.add();
    }

    @Override
    public void remove() {
        super.remove();
        this.name.remove();
    }

    @Override
    @NotNull
    public Point getAbsoluteOffset() {
        return new Point(24, 24);
    }

    @Override
    public int getWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getBounds().getHeight();
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getInsets() {
        return this.insets;
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return Rectangle.valueOf(this.getAbsoluteOffset(), this.getDimension()).expand(this.insets);
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle) {
        Rectangle drawBounds = this.getBounds();
        return !this.isHidden() && rectangle.intersects(drawBounds.getX(), drawBounds.getY(), 20000, drawBounds.getHeight());
    }

    private Dimension getDimension() {
        int maxX = 0;
        int maxY = 0;
        for (Drawable child : this.getDrawables().select(NOT_HIDDEN_PREDICATE)) {
            if (!(child instanceof DrawableFlowElement)) continue;
            DrawableFlowElement element = (DrawableFlowElement)child;
            int rightBound = element.getRightBound();
            maxX = Math.max(maxX, rightBound);
            int underBound = element.getUnderBound();
            maxY = Math.max(maxY, underBound);
        }
        return Dimension.valueOf(maxX + 48, maxY);
    }
}

