/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.collections.Sequence;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.diagram.draw.DrawableVerticalLabel;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class DrawablePoolLabel
extends DrawableVerticalLabel<Process> {
    private int lastHeight;
    private int lastPoolHeight = 0;
    private int lastProcessHeight;
    private String truncatedLabel;
    public static final int LANE_NAME_GAP = 25;

    public DrawablePoolLabel(@NotNull Drawable container, @NotNull DrawableProcess owner) {
        super(container, owner, DesignerLayer.PROCESS);
        this.setLabelLocation(DrawableLabel.LabelLocation.CENTER_LEFT);
        this.setHorizontalAlignment(DrawableLabel.HorizontalAlignment.CENTER);
        this.setVerticalAlignment(DrawableLabel.VerticalAlignment.CENTER);
    }

    @Override
    public Font getFont() {
        DrawContext context = this.getContext();
        Font font = context.getTheme().getLaneFont(this.isShowSelection());
        return font.larger(2);
    }

    @Override
    @NotNull
    public String getLabel() {
        if (this.truncatedLabel == null) {
            Process modelObject = (Process)this.getModelObject();
            String result = modelObject.getDefaultLabel();
            if (result == null) {
                result = modelObject.getName();
            }
            return result;
        }
        return this.truncatedLabel;
    }

    @Override
    @NotNull
    public DrawContext getContext() {
        return (DrawContext)super.getContext();
    }

    @Override
    public void refresh() {
        this.truncatedLabel = null;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.lastHeight = this.getOwner().getHeight();
        }
        super.refresh();
    }

    @Override
    protected Point getCenterLocationWithoutAlignment() {
        Point origin = this.getOwner().getBounds().getOrigin();
        return super.getCenterLocationWithoutAlignment().sub(origin).sub(12, 0);
    }

    @Override
    protected Rectangle getOwnerBounds() {
        DrawableProcess process = (DrawableProcess)this.getOwner();
        if (process.getHeight() != this.lastProcessHeight) {
            Sequence<DrawableFlowElement> lanes = process.getDrawablesAt(DesignerLayer.LANE_NAME);
            int totalHeight = 0;
            for (DrawableFlowElement drawableFlowElement : lanes) {
                totalHeight += drawableFlowElement.getBounds().getHeight();
            }
            this.lastPoolHeight = totalHeight;
            this.lastProcessHeight = process.getHeight();
        }
        Rectangle original = process.getBounds();
        Rectangle shrinked = original.shrink(process.getInsets());
        return Rectangle.valueOf(shrinked.getOrigin().sub(0, 12), shrinked.getWidth(), this.lastPoolHeight + 24);
    }

    @Override
    protected Color getLabelBackgroundColor() {
        return Color.FUEGO_LIGHT_BLUE;
    }

    @Override
    protected int calculateLabelHeight(@NotNull String label, @NotNull FontMetrics metrics) {
        int height = metrics.stringWidth(label);
        this.truncatedLabel = label;
        int ownerHeight = this.getOwnerBounds().getHeight() - 24;
        while (height > this.getContext().scale(ownerHeight) && label.length() > 0) {
            label = label.substring(0, label.length() - 1);
            this.truncatedLabel = label + "...";
            height = metrics.stringWidth(this.truncatedLabel);
        }
        return height;
    }

    @Override
    protected boolean needsUpdate() {
        boolean result = super.needsUpdate();
        return result |= this.getOwner().getHeight() != this.lastHeight;
    }
}

