/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.util.EnumSet;
import oracle.bpm.collections.Sequence;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawablesHolder;
import oracle.bpm.draw.DrawableDispatcher;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.NodeContainer;
import org.jetbrains.annotations.NotNull;

public abstract class DrawableNodeContainerImpl<T extends NodeContainer>
extends DrawableFlowElementImpl<T>
implements DrawableNodeContainer<T> {
    private DrawableDispatcher dispatcher;

    protected DrawableNodeContainerImpl(Drawable container, @NotNull T modelObject, @NotNull DesignerLayer layer) {
        super(container, modelObject, layer);
    }

    @Override
    @NotNull
    public DrawablesHolder<DrawableFlowElement> getHolder() {
        return super.getHolder();
    }

    @NotNull
    public Sequence<DrawableFlowElement> getDrawableFlowElements() {
        return this.getHolder().getDrawables();
    }

    @Override
    @NotNull
    public Sequence<DrawableFlowElement> getDrawablesAt(@NotNull DesignerLayer layer) {
        return this.getHolder().getAtLayer(layer);
    }

    @Override
    @NotNull
    public Sequence<DrawableFlowElement> getDrawablesAt(@NotNull EnumSet<DesignerLayer> layers) {
        return this.getHolder().getAtLayers(layers);
    }

    @Override
    public boolean contains(@NotNull FlowElement element) {
        return this.getDrawableFor(element) != null;
    }

    @Override
    public DrawableFlowElement getDrawableFor(@NotNull Object element) {
        return this.getHolder().getDrawableFor(element);
    }

    @Override
    @NotNull
    public DrawableFlowElement asDrawable(@NotNull FlowElement flowElement) {
        DrawableFlowElement result = this.getDrawableFor(flowElement);
        if (result == null) {
            throw new IllegalStateException("Drawable for ModelObject: " + flowElement + " not found");
        }
        return result;
    }
}

