/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.util.Locale;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.diagram.draw.DrawableMultiLineLabel;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Insets;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class DrawableFlowElementLabel<T extends FlowElement>
extends DrawableMultiLineLabel<T> {
    private DrawableFlowElementLabel(@NotNull Drawable container, @NotNull Drawable<T> owner) {
        super(container, owner);
        this.setInsets(Insets.valueOf(0, 0, 5, 0));
    }

    public static <T extends FlowElement> DrawableLabel<T> create(@NotNull Drawable container, @NotNull Drawable<T> owner) {
        return new DrawableFlowElementLabel<T>(container, owner);
    }

    @Override
    @NotNull
    public DrawContext getContext() {
        return (DrawContext)super.getContext();
    }

    @Override
    @NotNull
    public String getLabel() {
        Locale locale = this.getContext().getLocale();
        String label = null;
        if (locale != null) {
            label = ((FlowElement)this.getModelObject()).getLabel(locale);
        }
        if (Str.isEmpty(label)) {
            label = ((FlowElement)this.getModelObject()).getDefaultLabel();
        }
        return label != null ? label : "";
    }

    @Override
    public Font getFont() {
        return this.getContext().getTheme().getActivityFont(false);
    }

    @Override
    protected boolean shouldNotBeRendered() {
        return super.shouldNotBeRendered() || this.isBoundaryEvent();
    }

    private boolean isBoundaryEvent() {
        boolean result = false;
        if (this.getModelObject() instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)this.getModelObject();
            result = ModelUtils.isBoundaryEvent((FlowNode)flowNode);
        }
        return result;
    }
}

