/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.util.LinkedList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.diagram.draw.ChildrenPopulator;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableCreator;
import oracle.bpm.diagram.draw.GenericDrawableFactory;
import oracle.bpm.diagram.draw.renderer.ChildrenRenderer;
import oracle.bpm.diagram.draw.renderer.DebugContainerRenderer;
import oracle.bpm.draw.DrawableActivity;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.DrawableGateway;
import oracle.bpm.draw.DrawableLaneName;
import oracle.bpm.draw.DrawableMeasurement;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableNote;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.DrawableSubprocess;
import oracle.bpm.draw.renderer.FlowElementDraftRenderer;
import oracle.bpm.draw.renderer.FlowElementTemplateRenderer;
import oracle.bpm.draw.renderer.ProcessPoolRenderer;
import oracle.bpm.draw.renderer.ProcessRenderer;
import oracle.bpm.draw.renderer.ProcessTemplateRenderer;
import oracle.bpm.draw.renderer.SubprocessRenderer;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class BpmnDrawableFactory
extends GenericDrawableFactory {
    private static BpmnDrawableFactory instance;

    protected BpmnDrawableFactory() {
        this.creators();
        this.populators();
    }

    public static BpmnDrawableFactory getInstance() {
        if (instance == null) {
            instance = new BpmnDrawableFactory();
        }
        return instance;
    }

    protected void creators() {
        this.creator(this.processCreator());
        this.creator(this.laneCreator());
        this.creator(this.sequenceFlowCreator());
        this.creator(this.measurementCreator());
        this.creator(this.textAnnotationCreator());
        this.creator(this.subprocessCreator());
        this.creator(this.eventCreator());
        this.creator(this.gatewayCreator());
        this.creator(this.activityCreator());
    }

    protected void populators() {
        this.populator(this.processPopulator());
        this.populator(this.subprocessPopulator());
    }

    protected DrawableCreator processCreator() {
        return new DrawableCreator<Process>(Process.class){

            @Override
            protected Drawable create(@NotNull Drawable container, @NotNull Process process) {
                DrawableProcess drawable = new DrawableProcess(container, process);
                drawable.attachRenderer(ProcessRenderer.create(drawable));
                drawable.attachRenderer(ProcessPoolRenderer.create(drawable));
                drawable.attachRenderer(ChildrenRenderer.createUnclipped(drawable));
                drawable.attachRenderer(ProcessTemplateRenderer.create(drawable));
                drawable.attachRenderer(DebugContainerRenderer.create(drawable));
                return drawable;
            }
        };
    }

    protected DrawableCreator textAnnotationCreator() {
        return new NodeContainerCreator<TextAnnotation>(TextAnnotation.class){

            @Override
            protected Drawable create(@NotNull DrawableNodeContainer container, @NotNull TextAnnotation text) {
                DrawableNote drawable = new DrawableNote(container, text);
                drawable.attachRenderer(ChildrenRenderer.createClipped(drawable));
                return drawable;
            }
        };
    }

    protected DrawableCreator subprocessCreator() {
        return new NodeContainerCreator<Subprocess>(Subprocess.class){

            @Override
            protected Drawable create(@NotNull DrawableNodeContainer container, @NotNull Subprocess subprocess) {
                DrawableSubprocess drawable = new DrawableSubprocess(container, subprocess);
                drawable.attachRenderer(SubprocessRenderer.create(drawable));
                drawable.attachRenderer(ChildrenRenderer.createClipped(drawable));
                drawable.attachRenderer(DebugContainerRenderer.create(drawable));
                drawable.attachRenderer(FlowElementTemplateRenderer.create(drawable));
                drawable.attachRenderer(FlowElementDraftRenderer.create(drawable));
                return drawable;
            }

            @Override
            protected boolean check(@NotNull Drawable parent, @NotNull Subprocess subprocess) {
                return !ModelUtils.isCollapsed((Subprocess)subprocess) && super.check(parent, subprocess);
            }
        };
    }

    protected DrawableCreator eventCreator() {
        return new FlowNodeCreator<Event>(Event.class){

            @Override
            protected DrawableFlowNode subtype(@NotNull DrawableNodeContainer container, @NotNull Event event) {
                return new DrawableEvent(container, event);
            }

            @Override
            protected boolean check(@NotNull Drawable parent, @NotNull FlowNode flowNode) {
                return flowNode.isEvent() && super.check(parent, flowNode);
            }
        };
    }

    protected DrawableCreator gatewayCreator() {
        return new FlowNodeCreator<Gateway>(Gateway.class){

            @Override
            protected DrawableFlowNode subtype(@NotNull DrawableNodeContainer container, @NotNull Gateway gateway) {
                return new DrawableGateway(container, gateway);
            }

            @Override
            protected boolean check(@NotNull Drawable parent, @NotNull FlowNode flowNode) {
                return flowNode.isGateway() && super.check(parent, flowNode);
            }
        };
    }

    protected DrawableCreator activityCreator() {
        return new FlowNodeCreator<Activity>(Activity.class){

            @Override
            protected DrawableFlowNode subtype(@NotNull DrawableNodeContainer container, @NotNull Activity activity) {
                return new DrawableActivity(container, activity);
            }
        };
    }

    protected ChildrenPopulator processPopulator() {
        return new NodeContainerPopulator<Process>(Process.class){

            @Override
            protected void append(@NotNull List<Object> result, @NotNull Process process) {
                for (Lane lane : CollectionUtils.reverseIterable(process.getLanes())) {
                    result.add(lane);
                }
                for (TextAnnotation note : process.getTextAnnotations()) {
                    result.add(note);
                }
            }
        };
    }

    private DrawableCreator laneCreator() {
        return new NodeContainerCreator<Lane>(Lane.class){

            @Override
            protected Drawable create(@NotNull DrawableNodeContainer container, @NotNull Lane lane) {
                DrawableLaneName drawable = new DrawableLaneName(container, lane);
                drawable.attachRenderer(DebugContainerRenderer.create(drawable));
                return drawable;
            }
        };
    }

    private DrawableCreator sequenceFlowCreator() {
        return new NodeContainerCreator<SequenceFlow>(SequenceFlow.class){

            @Override
            protected Drawable create(@NotNull DrawableNodeContainer container, @NotNull SequenceFlow flow) {
                return new DrawableSequenceFlow(container, flow);
            }
        };
    }

    private DrawableCreator measurementCreator() {
        return new NodeContainerCreator<Measurement>(Measurement.class){

            @Override
            protected Drawable create(@NotNull DrawableNodeContainer container, @NotNull Measurement measurement) {
                DrawableMeasurement drawable = new DrawableMeasurement(container, measurement);
                drawable.attachRenderer(FlowElementTemplateRenderer.create(drawable));
                return drawable;
            }
        };
    }

    private ChildrenPopulator subprocessPopulator() {
        return new NodeContainerPopulator<Subprocess>(Subprocess.class){

            @Override
            protected boolean check(@NotNull NodeContainer container) {
                return super.check(container) && !ModelUtils.isCollapsed((Subprocess)((Subprocess)container));
            }
        };
    }

    protected static class NodeContainerPopulator<T extends NodeContainer>
    extends ChildrenPopulator<NodeContainer> {
        private final Class<T> subtype;

        protected NodeContainerPopulator(@NotNull Class<T> subtype) {
            super(NodeContainer.class);
            this.subtype = subtype;
        }

        @Override
        protected Iterable populate(@NotNull NodeContainer container) {
            LinkedList<Object> result = new LinkedList<Object>();
            this.populateFlowNodes(container, result);
            this.populateSequenceFlows(container, result);
            this.populateMeasurements(container, result);
            this.append(result, (NodeContainer)this.subtype.cast(container));
            return result;
        }

        protected void append(@NotNull List<Object> result, @NotNull T subtype) {
        }

        @Override
        protected boolean check(@NotNull NodeContainer container) {
            return this.subtype.isInstance(container);
        }

        private void populateMeasurements(NodeContainer container, List<Object> result) {
            for (Measurement measurement : container.getMeasurements()) {
                result.add(measurement);
            }
        }

        private void populateSequenceFlows(NodeContainer container, List<Object> result) {
            for (SequenceFlow flow : container.getSequenceFlows()) {
                result.add(flow);
            }
        }

        private void populateFlowNodes(NodeContainer container, List<Object> result) {
            for (FlowNode node : container.getFlowNodes()) {
                result.add(node);
                if (!node.isActivity()) continue;
                this.populateBoundaries(result, node);
            }
        }

        private void populateBoundaries(List<Object> result, FlowNode node) {
            for (BoundaryEvent boundary : ((Activity)node.asAnyNode(Activity.class)).getActivityBoundaryEvents()) {
                result.add(boundary);
            }
        }
    }

    protected static abstract class NodeContainerCreator<T>
    extends DrawableCreator<T> {
        protected NodeContainerCreator(@NotNull Class<T> clazz) {
            super(clazz);
        }

        protected abstract Drawable create(@NotNull DrawableNodeContainer var1, @NotNull T var2);

        @Override
        protected Drawable create(@NotNull Drawable container, @NotNull T element) {
            return this.create((DrawableNodeContainer)container, element);
        }

        @Override
        protected boolean check(@NotNull Drawable parent, @NotNull T element) {
            return parent instanceof DrawableNodeContainer;
        }
    }

    protected static abstract class FlowNodeCreator<T extends FlowNode>
    extends NodeContainerCreator<FlowNode> {
        protected final Class<T> subtype;

        protected FlowNodeCreator(@NotNull Class<T> subtype) {
            super(FlowNode.class);
            this.subtype = subtype;
        }

        protected abstract DrawableFlowNode subtype(@NotNull DrawableNodeContainer var1, @NotNull T var2);

        @Override
        protected Drawable create(@NotNull DrawableNodeContainer container, @NotNull FlowNode flowNode) {
            DrawableFlowNode drawable = this.subtype(container, flowNode.asAnyNode(this.subtype));
            drawable.attachRenderer(FlowElementTemplateRenderer.create(drawable));
            return drawable;
        }
    }
}

