/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import java.util.LinkedList;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.docx.Actor;

public abstract class Step {
    private String id;
    private int number;
    private FlowObject bpdNode;
    private Step nextStep;
    protected LinkedList<Step> prevSteps;
    protected LinkedList<Step> followingSteps;
    protected String sourceId;
    private ArrayList actors = new ArrayList();

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNextStep(Step nextStep) {
        this.nextStep = nextStep;
        this.addFollowingStep(nextStep, true);
    }

    public Step getNextStep() {
        return this.nextStep;
    }

    public ArrayList getActors() {
        return this.actors;
    }

    public void addActor(Actor actor) {
        if (this.actors == null) {
            this.actors = new ArrayList();
        }
        this.actors.add(actor);
    }

    public void setBpdNode(FlowObject node) {
        this.bpdNode = node;
    }

    public FlowObject getBpdNode() {
        return this.bpdNode;
    }

    protected void addPrevStep(Step step) {
        if (this.prevSteps == null) {
            this.prevSteps = new LinkedList();
        }
        this.prevSteps.add(step);
    }

    protected void addFollowingStep(Step step, boolean isFirstFollower) {
        if (this.followingSteps == null) {
            this.followingSteps = new LinkedList();
        }
        if (isFirstFollower) {
            this.followingSteps.add(0, step);
        } else {
            this.followingSteps.add(step);
        }
    }

    private void setPrevSteps(LinkedList prevSteps) {
        this.prevSteps = prevSteps;
    }

    private LinkedList getPrevSteps() {
        return this.prevSteps;
    }

    private void setFollowingSteps(LinkedList followingSteps) {
        this.followingSteps = followingSteps;
    }

    private LinkedList getFollowingSteps() {
        return this.followingSteps;
    }

    protected void setSourceId(String bpd_source_id) {
        this.sourceId = bpd_source_id;
    }

    protected String getSourceId() {
        return this.sourceId;
    }
}

