/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.util.ArrayList;
import oracle.tutor.docx.ExternalLinkObject;
import oracle.tutor.docx.LanguageMap;
import oracle.tutor.docx.Link;
import oracle.tutor.docx.Utils;

public class PriorActivity {
    private ArrayList mActivities = new ArrayList();
    private LanguageMap lm;

    public PriorActivity(LanguageMap lm) {
        this.lm = lm;
    }

    public void addActivity(String data) {
        ExternalLinkObject elo = this.string2ExLo(data);
        if (elo.getFileReference() != "") {
            this.mActivities.add(elo);
        }
    }

    public ArrayList getMActivities() {
        return this.mActivities;
    }

    private ExternalLinkObject string2ExLo(String data) {
        Link l = new Link(data);
        String url = l.getLinkUrl();
        String name = l.getLinkString();
        ExternalLinkObject lo = new ExternalLinkObject(url, name);
        return lo;
    }

    public String toDocx(String guid) {
        String pa = "";
        if (this.getMActivities().size() > 0) {
            pa = pa + " <w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "   <w:pPr>\n" + "       <w:pStyle w:val=\"SectionTitle\"/>\n" + "   </w:pPr>\n" + "   <w:r>\n" + " <w:t>" + this.lm.getFirstValue("Prior Activity") + "</w:t>\n" + "   </w:r>\n" + " </w:p>\n";
        }
        for (int i = 0; i < this.getMActivities().size(); ++i) {
            pa = pa + " <w:p w:rsidR=\"" + guid + "\" w:rsidRDefault=\"" + guid + "\">\n" + "   <w:pPr>\n" + "       <w:pStyle w:val=\"BodyText\"/>\n" + "\t<w:rPr>\n" + "         <w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t  <w:i/>\n" + "\t  <w:iCs/>\n" + "\t  <w:u w:val=\"single\"/>\n" + "      </w:rPr>\n" + "   </w:pPr>\n" + "   <w:r>\n" + "\t<w:rPr>\n" + "\t  <w:rFonts w:cs=\"Times New Roman\"/>\n" + "\t  <w:i/>\n" + "\t  <w:iCs/>\n" + "\t  <w:u w:val=\"single\"/>\n" + "\t</w:rPr>\n" + "       <w:t>" + Utils.formatEntityNotation(((ExternalLinkObject)this.getMActivities().get(i)).getFileReferenceName()) + " [";
            String[] tmp = ((ExternalLinkObject)this.getMActivities().get(i)).getFileReference().split("_pa");
            pa = pa + Utils.formatEntityNotation(tmp[0]);
            pa = pa + "]</w:t>\n   </w:r>\n </w:p>\n";
        }
        return pa;
    }
}

