/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.docx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class LanguageMap {
    private String[] mActionTypesArray;
    private String mAuthorDir;
    private String mLangFile;
    private HashMap mDefaultMap = new HashMap();
    private HashMap mMap = new HashMap();
    private HashMap mReverseMap = new HashMap();
    private String mCurrentKey;
    private ArrayList mCurrentValues;
    private String mRequestedLanguage;
    private Boolean mIsDefaultLanguage;
    static String[] mConditions = new String[]{"If", "Otherwise"};
    static String[] mActionTypes = new String[]{"Goto", "Return to", "Stop and complete", "End of activity"};

    public LanguageMap(String authorDir, String language) {
        this.mAuthorDir = authorDir;
        this.mLangFile = authorDir + "\\Language.rul";
        this.mRequestedLanguage = language;
        this.mIsDefaultLanguage = false;
        this.makeDefaultMap();
        File langFile = new File(this.mLangFile);
        if (langFile.exists()) {
            this.addAuthorRulFileStrings();
            this.setMap();
        } else {
            this.mIsDefaultLanguage = true;
            this.validateMapAgainstDefault();
        }
        this.mActionTypesArray = this.setLocalizedActionTypesArray();
    }

    private static String[] splitLine(String line) {
        String[] sp = line.split("\\t(\\t|\\s)*");
        if (sp[1].matches("")) {
            sp[1] = sp[sp.length - 1];
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMap() {
        try {
            Boolean langExists = false;
            File lf = new File(this.mLangFile);
            if (lf.exists()) {
                String line1;
                BufferedReader br1 = new BufferedReader(new FileReader(this.mLangFile));
                while ((line1 = br1.readLine()) != null) {
                    if (!line1.startsWith("Language") || !line1.endsWith(this.mRequestedLanguage)) continue;
                    langExists = true;
                    break;
                }
                br1.close();
            }
            if (!langExists.booleanValue()) {
                this.mIsDefaultLanguage = true;
                this.validateMapAgainstDefault();
                return;
            }
            if (!this.mIsDefaultLanguage.booleanValue()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.mLangFile));
                Boolean matched = false;
                while ((line = br.readLine()) != null) {
                    String[] spl;
                    if (line.startsWith("#")) continue;
                    if (line.startsWith("Language") && !matched.booleanValue()) {
                        if (!line.endsWith(this.mRequestedLanguage)) continue;
                        matched = true;
                        spl = LanguageMap.splitLine(line);
                        this.add2Map(spl[0], spl[1]);
                        if (!this.mDefaultMap.containsKey(spl[0])) continue;
                        this.mDefaultMap.remove(spl[0]);
                        continue;
                    }
                    if (!line.startsWith("Language") && matched.booleanValue()) {
                        spl = LanguageMap.splitLine(line);
                        this.add2Map(spl[0], spl[1]);
                        if (!this.mDefaultMap.containsKey(spl[0])) continue;
                        this.mDefaultMap.remove(spl[0]);
                        continue;
                    }
                    if (!line.startsWith("Language") || !matched.booleanValue()) continue;
                    return;
                }
                br.close();
            }
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(1);
        }
        finally {
            this.add2Map("", "");
        }
    }

    private void add2Map(String key, String value) {
        if (value.matches("Prior Activity")) {
            // empty if block
        }
        if (!key.matches("") && this.mCurrentKey == null) {
            this.mCurrentKey = key;
            this.mCurrentValues = new ArrayList();
        }
        if (this.mCurrentKey.equals(key)) {
            this.mCurrentValues.add(value);
        } else {
            this.mMap.put(this.mCurrentKey, this.mCurrentValues);
            this.mCurrentKey = key;
            this.mCurrentValues = new ArrayList();
            this.mCurrentValues.add(value);
        }
        if (key.matches("") && value.matches("")) {
            this.mMap.put(this.mCurrentKey, this.mCurrentValues);
        }
        if (!(key.matches("") || value.matches("") || this.mReverseMap.containsKey(value))) {
            this.mReverseMap.put(value, key);
        }
    }

    private void makeDefaultMap() {
        this.mDefaultMap.put("Language", "English (US)");
        this.mDefaultMap.put("Apps Code", "US");
        this.mDefaultMap.put("*Code Page", "1252");
        this.mDefaultMap.put("*Grammar Type", "0");
        this.mDefaultMap.put("System References", "System References");
        this.mDefaultMap.put("Scope", "Scope");
        this.mDefaultMap.put("Policy", "Policy");
        this.mDefaultMap.put("Responsibility", "Responsibility");
        this.mDefaultMap.put("Distribution", "Distribution");
        this.mDefaultMap.put("Ownership", "Ownership");
        this.mDefaultMap.put("Preface", "Activity Preface");
        this.mDefaultMap.put("Prior Activity", "Prior Activity");
        this.mDefaultMap.put("Subject", "Subject");
        this.mDefaultMap.put("Reference", "Reference");
        this.mDefaultMap.put("Effective", "Effective");
        this.mDefaultMap.put("And", "And");
        this.mDefaultMap.put("Or", "Or");
        this.mDefaultMap.put("<generic>", "<article><title of><generic job title><refers to>");
        this.mDefaultMap.put("<article>", "the");
        this.mDefaultMap.put("<title of>", "job title");
        this.mDefaultMap.put("<refers to>", "refers to");
        this.mDefaultMap.put("<owner>", "<article><owner job title><is><responsible><for>");
        this.mDefaultMap.put("<job description>", "<article><resp job title><is><responsible><for>");
        this.mDefaultMap.put("<is>", "is");
        this.mDefaultMap.put("<responsible>", "responsible");
        this.mDefaultMap.put("<for>", "for");
        this.mDefaultMap.put("If", "If");
        this.mDefaultMap.put("Otherwise", "Otherwise");
        this.mDefaultMap.put("Goto", "Goto");
        this.mDefaultMap.put("Return to", "Return to");
        this.mDefaultMap.put("Stop and complete", "Stop and complete");
        this.mDefaultMap.put("End of activity", "End of activity");
        this.mDefaultMap.put("Task #", "Task #");
        this.mDefaultMap.put("Repeat", "Repeat");
        this.mDefaultMap.put("Until", "Until");
        this.mDefaultMap.put("In parallel:", "In parallel:");
        this.mDefaultMap.put("Table of Contents", "Table of Contents");
        this.mDefaultMap.put("*Desk Manual", "Desk Manual");
        this.mDefaultMap.put("*Owner Manual", "Owner Manual");
        this.mDefaultMap.put("*Student Guide", "Student Guide");
        this.mDefaultMap.put("*Instructor Guide", "Instructor Guide");
        this.mDefaultMap.put("*Chapter", "Chapter");
        this.mDefaultMap.put("*Page", "Page");
        this.mDefaultMap.put("*Procedures", "Procedures");
        this.mDefaultMap.put("*Nav Instructions", "Navigation Instructions");
        this.mDefaultMap.put("*Instructions", "Instructions");
        this.mDefaultMap.put("*Coding Conventions", "Coding Conventions");
        this.mDefaultMap.put("*Business Forms", "Business Forms");
        this.mDefaultMap.put("*Reference Doc", "Reference Documents");
        this.mDefaultMap.put("*Curriculum Doc", "Curriculum Documents");
        this.mDefaultMap.put("*Education Overviews", "Education Overviews");
        this.mDefaultMap.put("*Labs", "Labs");
        this.mDefaultMap.put("*Actor to Screen", "Actor to Oracle Application Screen");
        this.mDefaultMap.put("*Discrepant Doc Ref", "Discrepant Document References");
        this.mDefaultMap.put("*Doc Master List", "Documents Master List");
        this.mDefaultMap.put("*Job Title to Doc", "Job Title to Documents");
        this.mDefaultMap.put("*Job Title to Resp", "Job Title to Responsibility Statement");
        this.mDefaultMap.put("*Screen to Actor", "Oracle Application Screen to Actor");
        this.mDefaultMap.put("*Screen to Doc", "Oracle Application Screen to Document");
        this.mDefaultMap.put("*Policy to Procedure", "Policy to Procedure");
        this.mDefaultMap.put("*Target Link to Doc", "Target Link to Documents");
        this.mDefaultMap.put("*Doc to Target Link", "Document to Target Links");
        this.mDefaultMap.put("*Copyright", "Copyright");
        this.mDefaultMap.put("*All Rights Reserved", "All rights reserved");
        this.mDefaultMap.put("*Start", "Start");
        this.mDefaultMap.put("*End", "End");
        this.mDefaultMap.put("*Yes", "Yes");
        this.mDefaultMap.put("*No", "No");
        this.mDefaultMap.put("*Application Control", "**Application Control**");
        this.mDefaultMap.put("*Manual Control", "**Manual Control**");
        this.mDefaultMap.put("*Exception", "**Exception**");
        this.mDefaultMap.put("*Flow?", "1");
        this.mDefaultMap.put("*Flow Title Font", "Times New Roman, 18");
        this.mDefaultMap.put("*Flow Text Font", "Arial, 34");
    }

    private void validateMapAgainstDefault() {
        for (Object o : this.mDefaultMap.keySet()) {
            String v = (String)this.mDefaultMap.get(o);
            this.add2Map((String)o, v);
        }
        if (this.mIsDefaultLanguage.booleanValue()) {
            this.add2Map("Task #", "Task #");
            this.add2Map("Task #", "Task#");
            this.add2Map("Task #", "Tasks #");
            this.add2Map("Task #", "Tasks#");
        }
    }

    private void addAuthorRulFileStrings() {
        String authorRulFilePath = this.mAuthorDir + "\\AUTHOR.RUL";
        File aRule = new File(authorRulFilePath);
        if (aRule.exists()) {
            try {
                String line1;
                Boolean langExists = false;
                Boolean isDefaultLanguage = true;
                BufferedReader br1 = new BufferedReader(new FileReader(authorRulFilePath));
                while ((line1 = br1.readLine()) != null) {
                    if (!line1.startsWith("Language") || !line1.endsWith(this.mRequestedLanguage)) continue;
                    langExists = true;
                    break;
                }
                if (!langExists.booleanValue()) {
                    isDefaultLanguage = true;
                    this.validateMapAgainstDefault();
                    return;
                }
                br1.close();
                if (!isDefaultLanguage.booleanValue()) {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(authorRulFilePath));
                    Boolean matched = false;
                    while ((line = br.readLine()) != null) {
                        String[] spl;
                        if (line.startsWith("#")) continue;
                        if (line.startsWith("Language") && !matched.booleanValue()) {
                            if (!line.endsWith(this.mRequestedLanguage)) continue;
                            matched = true;
                            spl = LanguageMap.splitLine(line);
                            this.add2Map(spl[0], spl[1]);
                            if (!this.mDefaultMap.containsKey(spl[0])) continue;
                            this.mDefaultMap.remove(spl[0]);
                            continue;
                        }
                        if (!line.startsWith("Language") && matched.booleanValue()) {
                            spl = LanguageMap.splitLine(line);
                            this.add2Map(spl[0], spl[1]);
                            if (!this.mDefaultMap.containsKey(spl[0])) continue;
                            this.mDefaultMap.remove(spl[0]);
                            continue;
                        }
                        if (!line.startsWith("Language") || !matched.booleanValue()) continue;
                        return;
                    }
                    br.close();
                }
            }
            catch (IOException e) {
                System.err.println(e);
                System.exit(1);
            }
        }
    }

    private String[] setLocalizedActionTypesArray() {
        int sum = 0;
        int arrayItemNumber = 0;
        ArrayList gt = this.getLocalizedValues("Goto");
        sum += gt.size();
        ArrayList rt = this.getLocalizedValues("Return to");
        sum += rt.size();
        ArrayList sc = this.getLocalizedValues("Stop and complete");
        sum += sc.size();
        ArrayList ea = this.getLocalizedValues("End of activity");
        String[] ActionArray = new String[sum += ea.size()];
        for (Object value : gt.subList(0, gt.size())) {
            ActionArray[arrayItemNumber++] = (String)value;
        }
        for (Object value : rt.subList(0, rt.size())) {
            ActionArray[arrayItemNumber++] = (String)value;
        }
        for (Object value : sc.subList(0, sc.size())) {
            ActionArray[arrayItemNumber++] = (String)value;
        }
        for (Object value : ea.subList(0, ea.size())) {
            ActionArray[arrayItemNumber++] = (String)value;
        }
        return ActionArray;
    }

    public String[] getLocalizedActionTypesArray() {
        return this.mActionTypesArray;
    }

    public int getMapSize() {
        return this.mMap.size();
    }

    public int getReverseMapSize() {
        return this.mReverseMap.size();
    }

    public ArrayList getLocalizedValues(String key) {
        if (this.mMap.containsKey(key)) {
            return (ArrayList)this.mMap.get(key);
        }
        return new ArrayList();
    }

    public String getKeyFromReverseValues(String value) {
        return (String)this.mReverseMap.get(value);
    }

    public Object getFirstValue(String s) {
        ArrayList list = this.getLocalizedValues(s);
        String firstValue = "";
        for (Object value : list.subList(0, 1)) {
            firstValue = value;
        }
        return firstValue;
    }

    public HashMap getConditionalsMap() {
        HashMap cm = new HashMap();
        for (int i = 0; i < mConditions.length; ++i) {
            cm.put(mConditions[i], this.mMap.get(mConditions[i]));
        }
        return cm;
    }

    public int getGrammarType() {
        int gt = 0;
        ArrayList gtl = this.getLocalizedValues("*Grammar Type");
        for (Object value : gtl.subList(0, gtl.size())) {
            String s = (String)value;
            gt = Integer.parseInt(s);
        }
        return gt;
    }
}

